%------------------------------------------------------------------------------
% File     : NUM925^2 : TPTP v7.4.0. Released v5.3.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 192, 500 axioms selected
% Version  : Especial.
% English  :

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla11] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla11]
% Names    : s2s_500_thf_l192 [Bla11]

% Status   : Theorem
% Rating   : 0.14 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.29 v6.1.0, 0.43 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0
% Syntax   : Number of formulae    :  741 (   0 unit;  38 type;   0 defn)
%            Number of atoms       : 6414 ( 466 equality;2700 variable)
%            Maximal formula depth :   14 (   7 average)
%            Number of connectives : 4880 ( 101   ~;  19   |;  49   &;4044   @)
%                                         ( 195 <=>; 472  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   49 (  49   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   42 (  38   :;   0   =)
%            Number of variables   : 1269 (   0 sgn;1257   !;  12   ?;   0   ^)
%                                         (1269   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-08-09 19:37:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
thf(ty_ty_tc__Int__Oint,type,(
    int: $tType )).

thf(ty_ty_tc__Nat__Onat,type,(
    nat: $tType )).

thf(ty_ty_tc__RealDef__Oreal,type,(
    real: $tType )).

%----Explicit typings (35)
thf(sy_c_Groups_Oone__class_Oone_000tc__Int__Oint,type,(
    one_one_int: int )).

thf(sy_c_Groups_Oone__class_Oone_000tc__Nat__Onat,type,(
    one_one_nat: nat )).

thf(sy_c_Groups_Oone__class_Oone_000tc__RealDef__Oreal,type,(
    one_one_real: real )).

thf(sy_c_Groups_Oplus__class_Oplus_000tc__Int__Oint,type,(
    plus_plus_int: int > int > int )).

thf(sy_c_Groups_Oplus__class_Oplus_000tc__Nat__Onat,type,(
    plus_plus_nat: nat > nat > nat )).

thf(sy_c_Groups_Oplus__class_Oplus_000tc__RealDef__Oreal,type,(
    plus_plus_real: real > real > real )).

thf(sy_c_Groups_Otimes__class_Otimes_000tc__Int__Oint,type,(
    times_times_int: int > int > int )).

thf(sy_c_Groups_Ozero__class_Ozero_000tc__Int__Oint,type,(
    zero_zero_int: int )).

thf(sy_c_Groups_Ozero__class_Ozero_000tc__Nat__Onat,type,(
    zero_zero_nat: nat )).

thf(sy_c_Groups_Ozero__class_Ozero_000tc__RealDef__Oreal,type,(
    zero_zero_real: real )).

thf(sy_c_If_000tc__Nat__Onat,type,(
    if_nat: $o > nat > nat > nat )).

thf(sy_c_Int_OBit0,type,(
    bit0: int > int )).

thf(sy_c_Int_OBit1,type,(
    bit1: int > int )).

thf(sy_c_Int_OPls,type,(
    pls: int )).

thf(sy_c_Int_Onumber__class_Onumber__of_000tc__Int__Oint,type,(
    number_number_of_int: int > int )).

thf(sy_c_Int_Onumber__class_Onumber__of_000tc__Nat__Onat,type,(
    number_number_of_nat: int > nat )).

thf(sy_c_Int_Onumber__class_Onumber__of_000tc__RealDef__Oreal,type,(
    number267125858f_real: int > real )).

thf(sy_c_Int_Osucc,type,(
    succ: int > int )).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_000tc__Int__Oint,type,(
    semiri1621563631at_int: nat > int )).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_000tc__Nat__Onat,type,(
    semiri984289939at_nat: nat > nat )).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_000tc__RealDef__Oreal,type,(
    semiri132038758t_real: nat > real )).

thf(sy_c_NthRoot_Osqrt,type,(
    sqrt: real > real )).

thf(sy_c_Orderings_Oord__class_Oless_000tc__Int__Oint,type,(
    ord_less_int: int > int > $o )).

thf(sy_c_Orderings_Oord__class_Oless_000tc__Nat__Onat,type,(
    ord_less_nat: nat > nat > $o )).

thf(sy_c_Orderings_Oord__class_Oless_000tc__RealDef__Oreal,type,(
    ord_less_real: real > real > $o )).

thf(sy_c_Orderings_Oord__class_Oless__eq_000tc__Int__Oint,type,(
    ord_less_eq_int: int > int > $o )).

thf(sy_c_Orderings_Oord__class_Oless__eq_000tc__Nat__Onat,type,(
    ord_less_eq_nat: nat > nat > $o )).

thf(sy_c_Orderings_Oord__class_Oless__eq_000tc__RealDef__Oreal,type,(
    ord_less_eq_real: real > real > $o )).

thf(sy_c_Power_Opower__class_Opower_000tc__Int__Oint,type,(
    power_power_int: int > nat > int )).

thf(sy_c_Power_Opower__class_Opower_000tc__Nat__Onat,type,(
    power_power_nat: nat > nat > nat )).

thf(sy_c_Power_Opower__class_Opower_000tc__RealDef__Oreal,type,(
    power_power_real: real > nat > real )).

thf(sy_v_m1____,type,(
    m1: int )).

thf(sy_v_n____,type,(
    n: nat )).

thf(sy_v_t____,type,(
    t: int )).

thf(sy_v_tn____,type,(
    tn: nat )).

%----Relevant facts (699)
thf(fact_0_n1pos,axiom,
    ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ one_one_int @ ( semiri1621563631at_int @ n ) ) )).

thf(fact_1_t1,axiom,
    ( ord_less_int @ one_one_int @ t )).

thf(fact_2_sum__power2__eq__zero__iff,axiom,(
    ! [X: int,Y: int] :
      ( ( ( plus_plus_int @ ( power_power_int @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
        = zero_zero_int )
    <=> ( ( X = zero_zero_int )
        & ( Y = zero_zero_int ) ) ) )).

thf(fact_3_sum__power2__eq__zero__iff,axiom,(
    ! [X: real,Y: real] :
      ( ( ( plus_plus_real @ ( power_power_real @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
        = zero_zero_real )
    <=> ( ( X = zero_zero_real )
        & ( Y = zero_zero_real ) ) ) )).

thf(fact_4_one__power2,axiom,
    ( ( power_power_int @ one_one_int @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = one_one_int )).

thf(fact_5_one__power2,axiom,
    ( ( power_power_nat @ one_one_nat @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = one_one_nat )).

thf(fact_6_one__power2,axiom,
    ( ( power_power_real @ one_one_real @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = one_one_real )).

thf(fact_7_zero__power2,axiom,
    ( ( power_power_int @ zero_zero_int @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = zero_zero_int )).

thf(fact_8_zero__power2,axiom,
    ( ( power_power_nat @ zero_zero_nat @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = zero_zero_nat )).

thf(fact_9_zero__power2,axiom,
    ( ( power_power_real @ zero_zero_real @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
    = zero_zero_real )).

thf(fact_10_zero__eq__power2,axiom,(
    ! [A_86: int] :
      ( ( ( power_power_int @ A_86 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
        = zero_zero_int )
    <=> ( A_86 = zero_zero_int ) ) )).

thf(fact_11_zero__eq__power2,axiom,(
    ! [A_86: real] :
      ( ( ( power_power_real @ A_86 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
        = zero_zero_real )
    <=> ( A_86 = zero_zero_real ) ) )).

thf(fact_12_add__special_I2_J,axiom,(
    ! [W_11: int] :
      ( ( plus_plus_int @ one_one_int @ ( number_number_of_int @ W_11 ) )
      = ( number_number_of_int @ ( plus_plus_int @ ( bit1 @ pls ) @ W_11 ) ) ) )).

thf(fact_13_add__special_I2_J,axiom,(
    ! [W_11: int] :
      ( ( plus_plus_real @ one_one_real @ ( number267125858f_real @ W_11 ) )
      = ( number267125858f_real @ ( plus_plus_int @ ( bit1 @ pls ) @ W_11 ) ) ) )).

thf(fact_14_add__special_I3_J,axiom,(
    ! [V_11: int] :
      ( ( plus_plus_int @ ( number_number_of_int @ V_11 ) @ one_one_int )
      = ( number_number_of_int @ ( plus_plus_int @ V_11 @ ( bit1 @ pls ) ) ) ) )).

thf(fact_15_add__special_I3_J,axiom,(
    ! [V_11: int] :
      ( ( plus_plus_real @ ( number267125858f_real @ V_11 ) @ one_one_real )
      = ( number267125858f_real @ ( plus_plus_int @ V_11 @ ( bit1 @ pls ) ) ) ) )).

thf(fact_16_one__add__one__is__two,axiom,
    ( ( plus_plus_int @ one_one_int @ one_one_int )
    = ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_17_one__add__one__is__two,axiom,
    ( ( plus_plus_real @ one_one_real @ one_one_real )
    = ( number267125858f_real @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_18_semiring__one__add__one__is__two,axiom,
    ( ( plus_plus_int @ one_one_int @ one_one_int )
    = ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_19_semiring__one__add__one__is__two,axiom,
    ( ( plus_plus_nat @ one_one_nat @ one_one_nat )
    = ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_20_semiring__one__add__one__is__two,axiom,
    ( ( plus_plus_real @ one_one_real @ one_one_real )
    = ( number267125858f_real @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_21_quartic__square__square,axiom,(
    ! [X: int] :
      ( ( power_power_int @ ( power_power_int @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
      = ( power_power_int @ X @ ( number_number_of_nat @ ( bit0 @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) ) )).

thf(fact_22_power__0__left__number__of,axiom,(
    ! [W_10: int] :
      ( ( ( ( number_number_of_nat @ W_10 )
          = zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ ( number_number_of_nat @ W_10 ) )
          = one_one_int ) )
      & ( ( ( number_number_of_nat @ W_10 )
         != zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ ( number_number_of_nat @ W_10 ) )
          = zero_zero_int ) ) ) )).

thf(fact_23_power__0__left__number__of,axiom,(
    ! [W_10: int] :
      ( ( ( ( number_number_of_nat @ W_10 )
          = zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ ( number_number_of_nat @ W_10 ) )
          = one_one_nat ) )
      & ( ( ( number_number_of_nat @ W_10 )
         != zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ ( number_number_of_nat @ W_10 ) )
          = zero_zero_nat ) ) ) )).

thf(fact_24_power__0__left__number__of,axiom,(
    ! [W_10: int] :
      ( ( ( ( number_number_of_nat @ W_10 )
          = zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ ( number_number_of_nat @ W_10 ) )
          = one_one_real ) )
      & ( ( ( number_number_of_nat @ W_10 )
         != zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ ( number_number_of_nat @ W_10 ) )
          = zero_zero_real ) ) ) )).

thf(fact_25_semiring__norm_I110_J,axiom,
    ( one_one_int
    = ( number_number_of_int @ ( bit1 @ pls ) ) )).

thf(fact_26_semiring__norm_I110_J,axiom,
    ( one_one_real
    = ( number267125858f_real @ ( bit1 @ pls ) ) )).

thf(fact_27_numeral__1__eq__1,axiom,
    ( ( number_number_of_int @ ( bit1 @ pls ) )
    = one_one_int )).

thf(fact_28_numeral__1__eq__1,axiom,
    ( ( number267125858f_real @ ( bit1 @ pls ) )
    = one_one_real )).

thf(fact_29_n0,axiom,
    ( ord_less_nat @ zero_zero_nat @ n )).

thf(fact_30_zless__linear,axiom,(
    ! [X: int,Y: int] :
      ( ( ord_less_int @ X @ Y )
      | ( X = Y )
      | ( ord_less_int @ Y @ X ) ) )).

thf(fact_31_less__number__of__int__code,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_int @ ( number_number_of_int @ K ) @ ( number_number_of_int @ L ) )
    <=> ( ord_less_int @ K @ L ) ) )).

thf(fact_32_plus__numeral__code_I9_J,axiom,(
    ! [V_1: int,W: int] :
      ( ( plus_plus_int @ ( number_number_of_int @ V_1 ) @ ( number_number_of_int @ W ) )
      = ( number_number_of_int @ ( plus_plus_int @ V_1 @ W ) ) ) )).

thf(fact_33_less__number__of,axiom,(
    ! [X_32: int,Y_26: int] :
      ( ( ord_less_int @ ( number_number_of_int @ X_32 ) @ ( number_number_of_int @ Y_26 ) )
    <=> ( ord_less_int @ X_32 @ Y_26 ) ) )).

thf(fact_34_less__number__of,axiom,(
    ! [X_32: int,Y_26: int] :
      ( ( ord_less_real @ ( number267125858f_real @ X_32 ) @ ( number267125858f_real @ Y_26 ) )
    <=> ( ord_less_int @ X_32 @ Y_26 ) ) )).

thf(fact_35_zero__is__num__zero,axiom,
    ( zero_zero_int
    = ( number_number_of_int @ pls ) )).

thf(fact_36_zpower__int,axiom,(
    ! [M: nat,N: nat] :
      ( ( power_power_int @ ( semiri1621563631at_int @ M ) @ N )
      = ( semiri1621563631at_int @ ( power_power_nat @ M @ N ) ) ) )).

thf(fact_37_int__power,axiom,(
    ! [M: nat,N: nat] :
      ( ( semiri1621563631at_int @ ( power_power_nat @ M @ N ) )
      = ( power_power_int @ ( semiri1621563631at_int @ M ) @ N ) ) )).

thf(fact_38_zadd__int__left,axiom,(
    ! [M: nat,N: nat,Z_2: int] :
      ( ( plus_plus_int @ ( semiri1621563631at_int @ M ) @ ( plus_plus_int @ ( semiri1621563631at_int @ N ) @ Z_2 ) )
      = ( plus_plus_int @ ( semiri1621563631at_int @ ( plus_plus_nat @ M @ N ) ) @ Z_2 ) ) )).

thf(fact_39_zadd__int,axiom,(
    ! [M: nat,N: nat] :
      ( ( plus_plus_int @ ( semiri1621563631at_int @ M ) @ ( semiri1621563631at_int @ N ) )
      = ( semiri1621563631at_int @ ( plus_plus_nat @ M @ N ) ) ) )).

thf(fact_40_int__1,axiom,
    ( ( semiri1621563631at_int @ one_one_nat )
    = one_one_int )).

thf(fact_41_nat__number__of__Pls,axiom,
    ( ( number_number_of_nat @ pls )
    = zero_zero_nat )).

thf(fact_42_semiring__norm_I113_J,axiom,
    ( zero_zero_nat
    = ( number_number_of_nat @ pls ) )).

thf(fact_43_int__eq__0__conv,axiom,(
    ! [N: nat] :
      ( ( ( semiri1621563631at_int @ N )
        = zero_zero_int )
    <=> ( N = zero_zero_nat ) ) )).

thf(fact_44_int__0,axiom,
    ( ( semiri1621563631at_int @ zero_zero_nat )
    = zero_zero_int )).

thf(fact_45_nat__1__add__1,axiom,
    ( ( plus_plus_nat @ one_one_nat @ one_one_nat )
    = ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_46_less__int__code_I16_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_int @ ( bit1 @ K1 ) @ ( bit1 @ K2 ) )
    <=> ( ord_less_int @ K1 @ K2 ) ) )).

thf(fact_47_rel__simps_I17_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_int @ ( bit1 @ K ) @ ( bit1 @ L ) )
    <=> ( ord_less_int @ K @ L ) ) )).

thf(fact_48_rel__simps_I2_J,axiom,(
    ~ ( ord_less_int @ pls @ pls ) )).

thf(fact_49_less__int__code_I13_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_int @ ( bit0 @ K1 ) @ ( bit0 @ K2 ) )
    <=> ( ord_less_int @ K1 @ K2 ) ) )).

thf(fact_50_rel__simps_I14_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_int @ ( bit0 @ K ) @ ( bit0 @ L ) )
    <=> ( ord_less_int @ K @ L ) ) )).

thf(fact_51_zadd__strict__right__mono,axiom,(
    ! [K: int,I: int,J: int] :
      ( ( ord_less_int @ I @ J )
     => ( ord_less_int @ ( plus_plus_int @ I @ K ) @ ( plus_plus_int @ J @ K ) ) ) )).

thf(fact_52_add__nat__number__of,axiom,(
    ! [V: int,V_1: int] :
      ( ( ( ord_less_int @ V_1 @ pls )
       => ( ( plus_plus_nat @ ( number_number_of_nat @ V_1 ) @ ( number_number_of_nat @ V ) )
          = ( number_number_of_nat @ V ) ) )
      & ( ~ ( ord_less_int @ V_1 @ pls )
       => ( ( ( ord_less_int @ V @ pls )
           => ( ( plus_plus_nat @ ( number_number_of_nat @ V_1 ) @ ( number_number_of_nat @ V ) )
              = ( number_number_of_nat @ V_1 ) ) )
          & ( ~ ( ord_less_int @ V @ pls )
           => ( ( plus_plus_nat @ ( number_number_of_nat @ V_1 ) @ ( number_number_of_nat @ V ) )
              = ( number_number_of_nat @ ( plus_plus_int @ V_1 @ V ) ) ) ) ) ) ) )).

thf(fact_53_one__is__num__one,axiom,
    ( one_one_int
    = ( number_number_of_int @ ( bit1 @ pls ) ) )).

thf(fact_54_nat__numeral__1__eq__1,axiom,
    ( ( number_number_of_nat @ ( bit1 @ pls ) )
    = one_one_nat )).

thf(fact_55_Numeral1__eq1__nat,axiom,
    ( one_one_nat
    = ( number_number_of_nat @ ( bit1 @ pls ) ) )).

thf(fact_56_eq__number__of,axiom,(
    ! [X_31: int,Y_25: int] :
      ( ( ( number_number_of_int @ X_31 )
        = ( number_number_of_int @ Y_25 ) )
    <=> ( X_31 = Y_25 ) ) )).

thf(fact_57_eq__number__of,axiom,(
    ! [X_31: int,Y_25: int] :
      ( ( ( number267125858f_real @ X_31 )
        = ( number267125858f_real @ Y_25 ) )
    <=> ( X_31 = Y_25 ) ) )).

thf(fact_58_number__of__reorient,axiom,(
    ! [W_9: int,X_30: nat] :
      ( ( ( number_number_of_nat @ W_9 )
        = X_30 )
    <=> ( X_30
        = ( number_number_of_nat @ W_9 ) ) ) )).

thf(fact_59_number__of__reorient,axiom,(
    ! [W_9: int,X_30: int] :
      ( ( ( number_number_of_int @ W_9 )
        = X_30 )
    <=> ( X_30
        = ( number_number_of_int @ W_9 ) ) ) )).

thf(fact_60_number__of__reorient,axiom,(
    ! [W_9: int,X_30: real] :
      ( ( ( number267125858f_real @ W_9 )
        = X_30 )
    <=> ( X_30
        = ( number267125858f_real @ W_9 ) ) ) )).

thf(fact_61_rel__simps_I51_J,axiom,(
    ! [K: int,L: int] :
      ( ( ( bit1 @ K )
        = ( bit1 @ L ) )
    <=> ( K = L ) ) )).

thf(fact_62_rel__simps_I48_J,axiom,(
    ! [K: int,L: int] :
      ( ( ( bit0 @ K )
        = ( bit0 @ L ) )
    <=> ( K = L ) ) )).

thf(fact_63_even__less__0__iff,axiom,(
    ! [A_85: int] :
      ( ( ord_less_int @ ( plus_plus_int @ A_85 @ A_85 ) @ zero_zero_int )
    <=> ( ord_less_int @ A_85 @ zero_zero_int ) ) )).

thf(fact_64_even__less__0__iff,axiom,(
    ! [A_85: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A_85 @ A_85 ) @ zero_zero_real )
    <=> ( ord_less_real @ A_85 @ zero_zero_real ) ) )).

thf(fact_65_zadd__assoc,axiom,(
    ! [Z1: int,Z2: int,Z3: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ Z1 @ Z2 ) @ Z3 )
      = ( plus_plus_int @ Z1 @ ( plus_plus_int @ Z2 @ Z3 ) ) ) )).

thf(fact_66_zadd__left__commute,axiom,(
    ! [X: int,Y: int,Z_2: int] :
      ( ( plus_plus_int @ X @ ( plus_plus_int @ Y @ Z_2 ) )
      = ( plus_plus_int @ Y @ ( plus_plus_int @ X @ Z_2 ) ) ) )).

thf(fact_67_zadd__commute,axiom,(
    ! [Z_2: int,W: int] :
      ( ( plus_plus_int @ Z_2 @ W )
      = ( plus_plus_int @ W @ Z_2 ) ) )).

thf(fact_68_int__int__eq,axiom,(
    ! [M: nat,N: nat] :
      ( ( ( semiri1621563631at_int @ M )
        = ( semiri1621563631at_int @ N ) )
    <=> ( M = N ) ) )).

thf(fact_69_less__special_I3_J,axiom,(
    ! [X_29: int] :
      ( ( ord_less_int @ ( number_number_of_int @ X_29 ) @ zero_zero_int )
    <=> ( ord_less_int @ X_29 @ pls ) ) )).

thf(fact_70_less__special_I3_J,axiom,(
    ! [X_29: int] :
      ( ( ord_less_real @ ( number267125858f_real @ X_29 ) @ zero_zero_real )
    <=> ( ord_less_int @ X_29 @ pls ) ) )).

thf(fact_71_less__special_I1_J,axiom,(
    ! [Y_24: int] :
      ( ( ord_less_int @ zero_zero_int @ ( number_number_of_int @ Y_24 ) )
    <=> ( ord_less_int @ pls @ Y_24 ) ) )).

thf(fact_72_less__special_I1_J,axiom,(
    ! [Y_24: int] :
      ( ( ord_less_real @ zero_zero_real @ ( number267125858f_real @ Y_24 ) )
    <=> ( ord_less_int @ pls @ Y_24 ) ) )).

thf(fact_73_rel__simps_I12_J,axiom,(
    ! [K: int] :
      ( ( ord_less_int @ ( bit1 @ K ) @ pls )
    <=> ( ord_less_int @ K @ pls ) ) )).

thf(fact_74_less__int__code_I15_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_int @ ( bit1 @ K1 ) @ ( bit0 @ K2 ) )
    <=> ( ord_less_int @ K1 @ K2 ) ) )).

thf(fact_75_rel__simps_I16_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_int @ ( bit1 @ K ) @ ( bit0 @ L ) )
    <=> ( ord_less_int @ K @ L ) ) )).

thf(fact_76_rel__simps_I10_J,axiom,(
    ! [K: int] :
      ( ( ord_less_int @ ( bit0 @ K ) @ pls )
    <=> ( ord_less_int @ K @ pls ) ) )).

thf(fact_77_rel__simps_I4_J,axiom,(
    ! [K: int] :
      ( ( ord_less_int @ pls @ ( bit0 @ K ) )
    <=> ( ord_less_int @ pls @ K ) ) )).

thf(fact_78_bin__less__0__simps_I4_J,axiom,(
    ! [W: int] :
      ( ( ord_less_int @ ( bit1 @ W ) @ zero_zero_int )
    <=> ( ord_less_int @ W @ zero_zero_int ) ) )).

thf(fact_79_bin__less__0__simps_I1_J,axiom,(
    ~ ( ord_less_int @ pls @ zero_zero_int ) )).

thf(fact_80_bin__less__0__simps_I3_J,axiom,(
    ! [W: int] :
      ( ( ord_less_int @ ( bit0 @ W ) @ zero_zero_int )
    <=> ( ord_less_int @ W @ zero_zero_int ) ) )).

thf(fact_81_int__0__less__1,axiom,
    ( ord_less_int @ zero_zero_int @ one_one_int )).

thf(fact_82_zless__add1__eq,axiom,(
    ! [W: int,Z_2: int] :
      ( ( ord_less_int @ W @ ( plus_plus_int @ Z_2 @ one_one_int ) )
    <=> ( ( ord_less_int @ W @ Z_2 )
        | ( W = Z_2 ) ) ) )).

thf(fact_83_int__less__0__conv,axiom,(
    ! [K: nat] :
      ~ ( ord_less_int @ ( semiri1621563631at_int @ K ) @ zero_zero_int ) )).

thf(fact_84_less__special_I4_J,axiom,(
    ! [X_28: int] :
      ( ( ord_less_int @ ( number_number_of_int @ X_28 ) @ one_one_int )
    <=> ( ord_less_int @ X_28 @ ( bit1 @ pls ) ) ) )).

thf(fact_85_less__special_I4_J,axiom,(
    ! [X_28: int] :
      ( ( ord_less_real @ ( number267125858f_real @ X_28 ) @ one_one_real )
    <=> ( ord_less_int @ X_28 @ ( bit1 @ pls ) ) ) )).

thf(fact_86_less__special_I2_J,axiom,(
    ! [Y_23: int] :
      ( ( ord_less_int @ one_one_int @ ( number_number_of_int @ Y_23 ) )
    <=> ( ord_less_int @ ( bit1 @ pls ) @ Y_23 ) ) )).

thf(fact_87_less__special_I2_J,axiom,(
    ! [Y_23: int] :
      ( ( ord_less_real @ one_one_real @ ( number267125858f_real @ Y_23 ) )
    <=> ( ord_less_int @ ( bit1 @ pls ) @ Y_23 ) ) )).

thf(fact_88_odd__less__0,axiom,(
    ! [Z_2: int] :
      ( ( ord_less_int @ ( plus_plus_int @ ( plus_plus_int @ one_one_int @ Z_2 ) @ Z_2 ) @ zero_zero_int )
    <=> ( ord_less_int @ Z_2 @ zero_zero_int ) ) )).

thf(fact_89_double__eq__0__iff,axiom,(
    ! [A_84: int] :
      ( ( ( plus_plus_int @ A_84 @ A_84 )
        = zero_zero_int )
    <=> ( A_84 = zero_zero_int ) ) )).

thf(fact_90_double__eq__0__iff,axiom,(
    ! [A_84: real] :
      ( ( ( plus_plus_real @ A_84 @ A_84 )
        = zero_zero_real )
    <=> ( A_84 = zero_zero_real ) ) )).

thf(fact_91_rel__simps_I46_J,axiom,(
    ! [K: int] :
      ( ( bit1 @ K )
     != pls ) )).

thf(fact_92_rel__simps_I39_J,axiom,(
    ! [L: int] :
      ( pls
     != ( bit1 @ L ) ) )).

thf(fact_93_rel__simps_I50_J,axiom,(
    ! [K: int,L: int] :
      ( ( bit1 @ K )
     != ( bit0 @ L ) ) )).

thf(fact_94_rel__simps_I49_J,axiom,(
    ! [K: int,L: int] :
      ( ( bit0 @ K )
     != ( bit1 @ L ) ) )).

thf(fact_95_rel__simps_I44_J,axiom,(
    ! [K: int] :
      ( ( ( bit0 @ K )
        = pls )
    <=> ( K = pls ) ) )).

thf(fact_96_rel__simps_I38_J,axiom,(
    ! [L: int] :
      ( ( pls
        = ( bit0 @ L ) )
    <=> ( pls = L ) ) )).

thf(fact_97_Bit0__Pls,axiom,
    ( ( bit0 @ pls )
    = pls )).

thf(fact_98_Pls__def,axiom,(
    pls = zero_zero_int )).

thf(fact_99_int__0__neq__1,axiom,(
    zero_zero_int != one_one_int )).

thf(fact_100_add__Pls__right,axiom,(
    ! [K: int] :
      ( ( plus_plus_int @ K @ pls )
      = K ) )).

thf(fact_101_add__Pls,axiom,(
    ! [K: int] :
      ( ( plus_plus_int @ pls @ K )
      = K ) )).

thf(fact_102_add__Bit0__Bit0,axiom,(
    ! [K: int,L: int] :
      ( ( plus_plus_int @ ( bit0 @ K ) @ ( bit0 @ L ) )
      = ( bit0 @ ( plus_plus_int @ K @ L ) ) ) )).

thf(fact_103_Bit0__def,axiom,(
    ! [K: int] :
      ( ( bit0 @ K )
      = ( plus_plus_int @ K @ K ) ) )).

thf(fact_104_zadd__0__right,axiom,(
    ! [Z_2: int] :
      ( ( plus_plus_int @ Z_2 @ zero_zero_int )
      = Z_2 ) )).

thf(fact_105_zadd__0,axiom,(
    ! [Z_2: int] :
      ( ( plus_plus_int @ zero_zero_int @ Z_2 )
      = Z_2 ) )).

thf(fact_106_semiring__numeral__0__eq__0,axiom,
    ( ( number_number_of_int @ pls )
    = zero_zero_int )).

thf(fact_107_semiring__numeral__0__eq__0,axiom,
    ( ( number_number_of_nat @ pls )
    = zero_zero_nat )).

thf(fact_108_semiring__numeral__0__eq__0,axiom,
    ( ( number267125858f_real @ pls )
    = zero_zero_real )).

thf(fact_109_number__of__Pls,axiom,
    ( ( number_number_of_int @ pls )
    = zero_zero_int )).

thf(fact_110_number__of__Pls,axiom,
    ( ( number267125858f_real @ pls )
    = zero_zero_real )).

thf(fact_111_semiring__norm_I112_J,axiom,
    ( zero_zero_int
    = ( number_number_of_int @ pls ) )).

thf(fact_112_semiring__norm_I112_J,axiom,
    ( zero_zero_real
    = ( number267125858f_real @ pls ) )).

thf(fact_113_add__numeral__0,axiom,(
    ! [A_83: int] :
      ( ( plus_plus_int @ ( number_number_of_int @ pls ) @ A_83 )
      = A_83 ) )).

thf(fact_114_add__numeral__0,axiom,(
    ! [A_83: real] :
      ( ( plus_plus_real @ ( number267125858f_real @ pls ) @ A_83 )
      = A_83 ) )).

thf(fact_115_add__numeral__0__right,axiom,(
    ! [A_82: int] :
      ( ( plus_plus_int @ A_82 @ ( number_number_of_int @ pls ) )
      = A_82 ) )).

thf(fact_116_add__numeral__0__right,axiom,(
    ! [A_82: real] :
      ( ( plus_plus_real @ A_82 @ ( number267125858f_real @ pls ) )
      = A_82 ) )).

thf(fact_117_power__eq__0__iff__number__of,axiom,(
    ! [A_81: int,W_8: int] :
      ( ( ( power_power_int @ A_81 @ ( number_number_of_nat @ W_8 ) )
        = zero_zero_int )
    <=> ( ( A_81 = zero_zero_int )
        & ( ( number_number_of_nat @ W_8 )
         != zero_zero_nat ) ) ) )).

thf(fact_118_power__eq__0__iff__number__of,axiom,(
    ! [A_81: nat,W_8: int] :
      ( ( ( power_power_nat @ A_81 @ ( number_number_of_nat @ W_8 ) )
        = zero_zero_nat )
    <=> ( ( A_81 = zero_zero_nat )
        & ( ( number_number_of_nat @ W_8 )
         != zero_zero_nat ) ) ) )).

thf(fact_119_power__eq__0__iff__number__of,axiom,(
    ! [A_81: real,W_8: int] :
      ( ( ( power_power_real @ A_81 @ ( number_number_of_nat @ W_8 ) )
        = zero_zero_real )
    <=> ( ( A_81 = zero_zero_real )
        & ( ( number_number_of_nat @ W_8 )
         != zero_zero_nat ) ) ) )).

thf(fact_120_add__number__of__left,axiom,(
    ! [V_10: int,W_7: int,Z_4: int] :
      ( ( plus_plus_int @ ( number_number_of_int @ V_10 ) @ ( plus_plus_int @ ( number_number_of_int @ W_7 ) @ Z_4 ) )
      = ( plus_plus_int @ ( number_number_of_int @ ( plus_plus_int @ V_10 @ W_7 ) ) @ Z_4 ) ) )).

thf(fact_121_add__number__of__left,axiom,(
    ! [V_10: int,W_7: int,Z_4: real] :
      ( ( plus_plus_real @ ( number267125858f_real @ V_10 ) @ ( plus_plus_real @ ( number267125858f_real @ W_7 ) @ Z_4 ) )
      = ( plus_plus_real @ ( number267125858f_real @ ( plus_plus_int @ V_10 @ W_7 ) ) @ Z_4 ) ) )).

thf(fact_122_add__number__of__eq,axiom,(
    ! [V_9: int,W_6: int] :
      ( ( plus_plus_int @ ( number_number_of_int @ V_9 ) @ ( number_number_of_int @ W_6 ) )
      = ( number_number_of_int @ ( plus_plus_int @ V_9 @ W_6 ) ) ) )).

thf(fact_123_add__number__of__eq,axiom,(
    ! [V_9: int,W_6: int] :
      ( ( plus_plus_real @ ( number267125858f_real @ V_9 ) @ ( number267125858f_real @ W_6 ) )
      = ( number267125858f_real @ ( plus_plus_int @ V_9 @ W_6 ) ) ) )).

thf(fact_124_number__of__add,axiom,(
    ! [V_8: int,W_5: int] :
      ( ( number_number_of_int @ ( plus_plus_int @ V_8 @ W_5 ) )
      = ( plus_plus_int @ ( number_number_of_int @ V_8 ) @ ( number_number_of_int @ W_5 ) ) ) )).

thf(fact_125_number__of__add,axiom,(
    ! [V_8: int,W_5: int] :
      ( ( number267125858f_real @ ( plus_plus_int @ V_8 @ W_5 ) )
      = ( plus_plus_real @ ( number267125858f_real @ V_8 ) @ ( number267125858f_real @ W_5 ) ) ) )).

thf(fact_126_add__Bit1__Bit0,axiom,(
    ! [K: int,L: int] :
      ( ( plus_plus_int @ ( bit1 @ K ) @ ( bit0 @ L ) )
      = ( bit1 @ ( plus_plus_int @ K @ L ) ) ) )).

thf(fact_127_add__Bit0__Bit1,axiom,(
    ! [K: int,L: int] :
      ( ( plus_plus_int @ ( bit0 @ K ) @ ( bit1 @ L ) )
      = ( bit1 @ ( plus_plus_int @ K @ L ) ) ) )).

thf(fact_128_Bit1__def,axiom,(
    ! [K: int] :
      ( ( bit1 @ K )
      = ( plus_plus_int @ ( plus_plus_int @ one_one_int @ K ) @ K ) ) )).

thf(fact_129_odd__nonzero,axiom,(
    ! [Z_2: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ one_one_int @ Z_2 ) @ Z_2 )
     != zero_zero_int ) )).

thf(fact_130_number__of__int,axiom,(
    ! [N_35: nat] :
      ( ( number_number_of_nat @ ( semiri1621563631at_int @ N_35 ) )
      = ( semiri984289939at_nat @ N_35 ) ) )).

thf(fact_131_number__of__int,axiom,(
    ! [N_35: nat] :
      ( ( number_number_of_int @ ( semiri1621563631at_int @ N_35 ) )
      = ( semiri1621563631at_int @ N_35 ) ) )).

thf(fact_132_number__of__int,axiom,(
    ! [N_35: nat] :
      ( ( number267125858f_real @ ( semiri1621563631at_int @ N_35 ) )
      = ( semiri132038758t_real @ N_35 ) ) )).

thf(fact_133_zero__less__power2,axiom,(
    ! [A_80: int] :
      ( ( ord_less_int @ zero_zero_int @ ( power_power_int @ A_80 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
    <=> ( A_80 != zero_zero_int ) ) )).

thf(fact_134_zero__less__power2,axiom,(
    ! [A_80: real] :
      ( ( ord_less_real @ zero_zero_real @ ( power_power_real @ A_80 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
    <=> ( A_80 != zero_zero_real ) ) )).

thf(fact_135_power2__less__0,axiom,(
    ! [A_79: int] :
      ~ ( ord_less_int @ ( power_power_int @ A_79 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ zero_zero_int ) )).

thf(fact_136_power2__less__0,axiom,(
    ! [A_79: real] :
      ~ ( ord_less_real @ ( power_power_real @ A_79 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ zero_zero_real ) )).

thf(fact_137_sum__power2__gt__zero__iff,axiom,(
    ! [X_27: int,Y_22: int] :
      ( ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ ( power_power_int @ X_27 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_22 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) )
    <=> ( ( X_27 != zero_zero_int )
        | ( Y_22 != zero_zero_int ) ) ) )).

thf(fact_138_sum__power2__gt__zero__iff,axiom,(
    ! [X_27: real,Y_22: real] :
      ( ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ ( power_power_real @ X_27 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_22 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) )
    <=> ( ( X_27 != zero_zero_real )
        | ( Y_22 != zero_zero_real ) ) ) )).

thf(fact_139_not__sum__power2__lt__zero,axiom,(
    ! [X_26: int,Y_21: int] :
      ~ ( ord_less_int @ ( plus_plus_int @ ( power_power_int @ X_26 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_21 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) @ zero_zero_int ) )).

thf(fact_140_not__sum__power2__lt__zero,axiom,(
    ! [X_26: real,Y_21: real] :
      ~ ( ord_less_real @ ( plus_plus_real @ ( power_power_real @ X_26 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_21 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) @ zero_zero_real ) )).

thf(fact_141_number__of__Bit0,axiom,(
    ! [W_4: int] :
      ( ( number_number_of_int @ ( bit0 @ W_4 ) )
      = ( plus_plus_int @ ( plus_plus_int @ zero_zero_int @ ( number_number_of_int @ W_4 ) ) @ ( number_number_of_int @ W_4 ) ) ) )).

thf(fact_142_number__of__Bit0,axiom,(
    ! [W_4: int] :
      ( ( number267125858f_real @ ( bit0 @ W_4 ) )
      = ( plus_plus_real @ ( plus_plus_real @ zero_zero_real @ ( number267125858f_real @ W_4 ) ) @ ( number267125858f_real @ W_4 ) ) ) )).

thf(fact_143_number__of__Bit1,axiom,(
    ! [W_3: int] :
      ( ( number_number_of_int @ ( bit1 @ W_3 ) )
      = ( plus_plus_int @ ( plus_plus_int @ one_one_int @ ( number_number_of_int @ W_3 ) ) @ ( number_number_of_int @ W_3 ) ) ) )).

thf(fact_144_number__of__Bit1,axiom,(
    ! [W_3: int] :
      ( ( number267125858f_real @ ( bit1 @ W_3 ) )
      = ( plus_plus_real @ ( plus_plus_real @ one_one_real @ ( number267125858f_real @ W_3 ) ) @ ( number267125858f_real @ W_3 ) ) ) )).

thf(fact_145_semiring__numeral__1__eq__1,axiom,
    ( ( number_number_of_int @ ( bit1 @ pls ) )
    = one_one_int )).

thf(fact_146_semiring__numeral__1__eq__1,axiom,
    ( ( number_number_of_nat @ ( bit1 @ pls ) )
    = one_one_nat )).

thf(fact_147_semiring__numeral__1__eq__1,axiom,
    ( ( number267125858f_real @ ( bit1 @ pls ) )
    = one_one_real )).

thf(fact_148_mn,axiom,
    ( ord_less_int @ m1 @ ( plus_plus_int @ one_one_int @ ( semiri1621563631at_int @ n ) ) )).

thf(fact_149_of__nat__less__two__power,axiom,(
    ! [N_34: nat] :
      ( ord_less_int @ ( semiri1621563631at_int @ N_34 ) @ ( power_power_int @ ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) @ N_34 ) ) )).

thf(fact_150_of__nat__less__two__power,axiom,(
    ! [N_34: nat] :
      ( ord_less_real @ ( semiri132038758t_real @ N_34 ) @ ( power_power_real @ ( number267125858f_real @ ( bit0 @ ( bit1 @ pls ) ) ) @ N_34 ) ) )).

thf(fact_151_transfer__int__nat__numerals_I3_J,axiom,
    ( ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) )
    = ( semiri1621563631at_int @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )).

thf(fact_152_transfer__int__nat__numerals_I4_J,axiom,
    ( ( number_number_of_int @ ( bit1 @ ( bit1 @ pls ) ) )
    = ( semiri1621563631at_int @ ( number_number_of_nat @ ( bit1 @ ( bit1 @ pls ) ) ) ) )).

thf(fact_153_realpow__two__sum__zero__iff,axiom,(
    ! [X: real,Y: real] :
      ( ( ( plus_plus_real @ ( power_power_real @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
        = zero_zero_real )
    <=> ( ( X = zero_zero_real )
        & ( Y = zero_zero_real ) ) ) )).

thf(fact_154_of__nat__0__less__iff,axiom,(
    ! [N_33: nat] :
      ( ( ord_less_int @ zero_zero_int @ ( semiri1621563631at_int @ N_33 ) )
    <=> ( ord_less_nat @ zero_zero_nat @ N_33 ) ) )).

thf(fact_155_of__nat__0__less__iff,axiom,(
    ! [N_33: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( semiri984289939at_nat @ N_33 ) )
    <=> ( ord_less_nat @ zero_zero_nat @ N_33 ) ) )).

thf(fact_156_of__nat__0__less__iff,axiom,(
    ! [N_33: nat] :
      ( ( ord_less_real @ zero_zero_real @ ( semiri132038758t_real @ N_33 ) )
    <=> ( ord_less_nat @ zero_zero_nat @ N_33 ) ) )).

thf(fact_157_one__less__power,axiom,(
    ! [N_32: nat,A_78: int] :
      ( ( ord_less_int @ one_one_int @ A_78 )
     => ( ( ord_less_nat @ zero_zero_nat @ N_32 )
       => ( ord_less_int @ one_one_int @ ( power_power_int @ A_78 @ N_32 ) ) ) ) )).

thf(fact_158_one__less__power,axiom,(
    ! [N_32: nat,A_78: nat] :
      ( ( ord_less_nat @ one_one_nat @ A_78 )
     => ( ( ord_less_nat @ zero_zero_nat @ N_32 )
       => ( ord_less_nat @ one_one_nat @ ( power_power_nat @ A_78 @ N_32 ) ) ) ) )).

thf(fact_159_one__less__power,axiom,(
    ! [N_32: nat,A_78: real] :
      ( ( ord_less_real @ one_one_real @ A_78 )
     => ( ( ord_less_nat @ zero_zero_nat @ N_32 )
       => ( ord_less_real @ one_one_real @ ( power_power_real @ A_78 @ N_32 ) ) ) ) )).

thf(fact_160_power__0__left,axiom,(
    ! [N_31: nat] :
      ( ( ( N_31 = zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N_31 )
          = one_one_int ) )
      & ( ( N_31 != zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N_31 )
          = zero_zero_int ) ) ) )).

thf(fact_161_power__0__left,axiom,(
    ! [N_31: nat] :
      ( ( ( N_31 = zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N_31 )
          = one_one_nat ) )
      & ( ( N_31 != zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N_31 )
          = zero_zero_nat ) ) ) )).

thf(fact_162_power__0__left,axiom,(
    ! [N_31: nat] :
      ( ( ( N_31 = zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N_31 )
          = one_one_real ) )
      & ( ( N_31 != zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N_31 )
          = zero_zero_real ) ) ) )).

thf(fact_163_power__strict__decreasing,axiom,(
    ! [A_77: int,N_30: nat,N_29: nat] :
      ( ( ord_less_nat @ N_30 @ N_29 )
     => ( ( ord_less_int @ zero_zero_int @ A_77 )
       => ( ( ord_less_int @ A_77 @ one_one_int )
         => ( ord_less_int @ ( power_power_int @ A_77 @ N_29 ) @ ( power_power_int @ A_77 @ N_30 ) ) ) ) ) )).

thf(fact_164_power__strict__decreasing,axiom,(
    ! [A_77: nat,N_30: nat,N_29: nat] :
      ( ( ord_less_nat @ N_30 @ N_29 )
     => ( ( ord_less_nat @ zero_zero_nat @ A_77 )
       => ( ( ord_less_nat @ A_77 @ one_one_nat )
         => ( ord_less_nat @ ( power_power_nat @ A_77 @ N_29 ) @ ( power_power_nat @ A_77 @ N_30 ) ) ) ) ) )).

thf(fact_165_power__strict__decreasing,axiom,(
    ! [A_77: real,N_30: nat,N_29: nat] :
      ( ( ord_less_nat @ N_30 @ N_29 )
     => ( ( ord_less_real @ zero_zero_real @ A_77 )
       => ( ( ord_less_real @ A_77 @ one_one_real )
         => ( ord_less_real @ ( power_power_real @ A_77 @ N_29 ) @ ( power_power_real @ A_77 @ N_30 ) ) ) ) ) )).

thf(fact_166_zero__less__two,axiom,
    ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ one_one_int @ one_one_int ) )).

thf(fact_167_zero__less__two,axiom,
    ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ one_one_nat @ one_one_nat ) )).

thf(fact_168_zero__less__two,axiom,
    ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ one_one_real @ one_one_real ) )).

thf(fact_169_int__gr__induct,axiom,(
    ! [P: int > $o,K: int,I: int] :
      ( ( ord_less_int @ K @ I )
     => ( ( P @ ( plus_plus_int @ K @ one_one_int ) )
       => ( ! [I_1: int] :
              ( ( ord_less_int @ K @ I_1 )
             => ( ( P @ I_1 )
               => ( P @ ( plus_plus_int @ I_1 @ one_one_int ) ) ) )
         => ( P @ I ) ) ) ) )).

thf(fact_170_tn0,axiom,
    ( ord_less_nat @ zero_zero_nat @ tn )).

thf(fact_171_less__zeroE,axiom,(
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) )).

thf(fact_172_real__zero__not__eq__one,axiom,(
    zero_zero_real != one_one_real )).

thf(fact_173_less__not__refl,axiom,(
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) )).

thf(fact_174_not__add__less1,axiom,(
    ! [I: nat,J: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ I @ J ) @ I ) )).

thf(fact_175_not__add__less2,axiom,(
    ! [J: nat,I: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ J @ I ) @ I ) )).

thf(fact_176_number__of__is__id,axiom,(
    ! [K: int] :
      ( ( number_number_of_int @ K )
      = K ) )).

thf(fact_177_nat__neq__iff,axiom,(
    ! [M: nat,N: nat] :
      ( ( M != N )
    <=> ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) )).

thf(fact_178_nat__add__commute,axiom,(
    ! [M: nat,N: nat] :
      ( ( plus_plus_nat @ M @ N )
      = ( plus_plus_nat @ N @ M ) ) )).

thf(fact_179_nat__add__left__commute,axiom,(
    ! [X: nat,Y: nat,Z_2: nat] :
      ( ( plus_plus_nat @ X @ ( plus_plus_nat @ Y @ Z_2 ) )
      = ( plus_plus_nat @ Y @ ( plus_plus_nat @ X @ Z_2 ) ) ) )).

thf(fact_180_nat__add__assoc,axiom,(
    ! [M: nat,N: nat,K: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ M @ N ) @ K )
      = ( plus_plus_nat @ M @ ( plus_plus_nat @ N @ K ) ) ) )).

thf(fact_181_nat__add__left__cancel,axiom,(
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus_nat @ K @ M )
        = ( plus_plus_nat @ K @ N ) )
    <=> ( M = N ) ) )).

thf(fact_182_nat__add__right__cancel,axiom,(
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ K )
        = ( plus_plus_nat @ N @ K ) )
    <=> ( M = N ) ) )).

thf(fact_183_nat__add__left__cancel__less,axiom,(
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
    <=> ( ord_less_nat @ M @ N ) ) )).

thf(fact_184_linorder__neqE__nat,axiom,(
    ! [X: nat,Y: nat] :
      ( ( X != Y )
     => ( ~ ( ord_less_nat @ X @ Y )
       => ( ord_less_nat @ Y @ X ) ) ) )).

thf(fact_185_less__irrefl__nat,axiom,(
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) )).

thf(fact_186_less__not__refl2,axiom,(
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) )).

thf(fact_187_less__not__refl3,axiom,(
    ! [S: nat,T: nat] :
      ( ( ord_less_nat @ S @ T )
     => ( S != T ) ) )).

thf(fact_188_trans__less__add1,axiom,(
    ! [M: nat,I: nat,J: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ I @ ( plus_plus_nat @ J @ M ) ) ) )).

thf(fact_189_trans__less__add2,axiom,(
    ! [M: nat,I: nat,J: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ I @ ( plus_plus_nat @ M @ J ) ) ) )).

thf(fact_190_add__less__mono1,axiom,(
    ! [K: nat,I: nat,J: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ K ) ) ) )).

thf(fact_191_add__less__mono,axiom,(
    ! [K: nat,L: nat,I: nat,J: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ( ord_less_nat @ K @ L )
       => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ) )).

thf(fact_192_less__add__eq__less,axiom,(
    ! [M: nat,N: nat,K: nat,L: nat] :
      ( ( ord_less_nat @ K @ L )
     => ( ( ( plus_plus_nat @ M @ L )
          = ( plus_plus_nat @ K @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) )).

thf(fact_193_add__lessD1,axiom,(
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ I @ J ) @ K )
     => ( ord_less_nat @ I @ K ) ) )).

thf(fact_194_nat__less__cases,axiom,(
    ! [P: nat > nat > $o,M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
       => ( P @ N @ M ) )
     => ( ( ( M = N )
         => ( P @ N @ M ) )
       => ( ( ( ord_less_nat @ N @ M )
           => ( P @ N @ M ) )
         => ( P @ N @ M ) ) ) ) )).

thf(fact_195_gr0I,axiom,(
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) )).

thf(fact_196_gr__implies__not0,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) )).

thf(fact_197_nat__power__less__imp__less,axiom,(
    ! [M: nat,N: nat,I: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ I )
     => ( ( ord_less_nat @ ( power_power_nat @ I @ M ) @ ( power_power_nat @ I @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) )).

thf(fact_198_less__nat__zero__code,axiom,(
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) )).

thf(fact_199_nat__zero__less__power__iff,axiom,(
    ! [X: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ X @ N ) )
    <=> ( ( ord_less_nat @ zero_zero_nat @ X )
        | ( N = zero_zero_nat ) ) ) )).

thf(fact_200_add__gr__0,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ M @ N ) )
    <=> ( ( ord_less_nat @ zero_zero_nat @ M )
        | ( ord_less_nat @ zero_zero_nat @ N ) ) ) )).

thf(fact_201_neq0__conv,axiom,(
    ! [N: nat] :
      ( ( N != zero_zero_nat )
    <=> ( ord_less_nat @ zero_zero_nat @ N ) ) )).

thf(fact_202_not__less0,axiom,(
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) )).

thf(fact_203_zero__less__power__nat__eq,axiom,(
    ! [X: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ X @ N ) )
    <=> ( ( N = zero_zero_nat )
        | ( ord_less_nat @ zero_zero_nat @ X ) ) ) )).

thf(fact_204_Nat__Transfer_Otransfer__int__nat__relations_I2_J,axiom,(
    ! [X: nat,Y: nat] :
      ( ( ord_less_int @ ( semiri1621563631at_int @ X ) @ ( semiri1621563631at_int @ Y ) )
    <=> ( ord_less_nat @ X @ Y ) ) )).

thf(fact_205_zero__less__power__nat__eq__number__of,axiom,(
    ! [X: nat,W: int] :
      ( ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ X @ ( number_number_of_nat @ W ) ) )
    <=> ( ( ( number_number_of_nat @ W )
          = zero_zero_nat )
        | ( ord_less_nat @ zero_zero_nat @ X ) ) ) )).

thf(fact_206_zless__int,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_int @ ( semiri1621563631at_int @ M ) @ ( semiri1621563631at_int @ N ) )
    <=> ( ord_less_nat @ M @ N ) ) )).

thf(fact_207_less__nat__number__of,axiom,(
    ! [V_1: int,V: int] :
      ( ( ord_less_nat @ ( number_number_of_nat @ V_1 ) @ ( number_number_of_nat @ V ) )
    <=> ( ( ( ord_less_int @ V_1 @ V )
         => ( ord_less_int @ pls @ V ) )
        & ( ord_less_int @ V_1 @ V ) ) ) )).

thf(fact_208_linorder__neqE__linordered__idom,axiom,(
    ! [X_25: real,Y_20: real] :
      ( ( X_25 != Y_20 )
     => ( ~ ( ord_less_real @ X_25 @ Y_20 )
       => ( ord_less_real @ Y_20 @ X_25 ) ) ) )).

thf(fact_209_linorder__neqE__linordered__idom,axiom,(
    ! [X_25: int,Y_20: int] :
      ( ( X_25 != Y_20 )
     => ( ~ ( ord_less_int @ X_25 @ Y_20 )
       => ( ord_less_int @ Y_20 @ X_25 ) ) ) )).

thf(fact_210_add__eq__self__zero,axiom,(
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = M )
     => ( N = zero_zero_nat ) ) )).

thf(fact_211_add__is__0,axiom,(
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = zero_zero_nat )
    <=> ( ( M = zero_zero_nat )
        & ( N = zero_zero_nat ) ) ) )).

thf(fact_212_Nat_Oadd__0__right,axiom,(
    ! [M: nat] :
      ( ( plus_plus_nat @ M @ zero_zero_nat )
      = M ) )).

thf(fact_213_plus__nat_Oadd__0,axiom,(
    ! [N: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ N )
      = N ) )).

thf(fact_214_power__one__right,axiom,(
    ! [A_76: real] :
      ( ( power_power_real @ A_76 @ one_one_nat )
      = A_76 ) )).

thf(fact_215_power__one__right,axiom,(
    ! [A_76: nat] :
      ( ( power_power_nat @ A_76 @ one_one_nat )
      = A_76 ) )).

thf(fact_216_power__one__right,axiom,(
    ! [A_76: int] :
      ( ( power_power_int @ A_76 @ one_one_nat )
      = A_76 ) )).

thf(fact_217_of__nat__eq__iff,axiom,(
    ! [M_13: nat,N_28: nat] :
      ( ( ( semiri132038758t_real @ M_13 )
        = ( semiri132038758t_real @ N_28 ) )
    <=> ( M_13 = N_28 ) ) )).

thf(fact_218_of__nat__eq__iff,axiom,(
    ! [M_13: nat,N_28: nat] :
      ( ( ( semiri984289939at_nat @ M_13 )
        = ( semiri984289939at_nat @ N_28 ) )
    <=> ( M_13 = N_28 ) ) )).

thf(fact_219_of__nat__eq__iff,axiom,(
    ! [M_13: nat,N_28: nat] :
      ( ( ( semiri1621563631at_int @ M_13 )
        = ( semiri1621563631at_int @ N_28 ) )
    <=> ( M_13 = N_28 ) ) )).

thf(fact_220_Nat__Transfer_Otransfer__int__nat__relations_I1_J,axiom,(
    ! [X: nat,Y: nat] :
      ( ( ( semiri1621563631at_int @ X )
        = ( semiri1621563631at_int @ Y ) )
    <=> ( X = Y ) ) )).

thf(fact_221_int__if__cong,axiom,(
    ! [X: nat,Y: nat,P: $o] :
      ( ( P
       => ( ( semiri1621563631at_int @ X )
          = ( semiri1621563631at_int @ ( if_nat @ P @ X @ Y ) ) ) )
      & ( ~ ( P )
       => ( ( semiri1621563631at_int @ Y )
          = ( semiri1621563631at_int @ ( if_nat @ P @ X @ Y ) ) ) ) ) )).

thf(fact_222_less__0__number__of,axiom,(
    ! [V_1: int] :
      ( ( ord_less_nat @ zero_zero_nat @ ( number_number_of_nat @ V_1 ) )
    <=> ( ord_less_int @ pls @ V_1 ) ) )).

thf(fact_223_zero__less__int__conv,axiom,(
    ! [N: nat] :
      ( ( ord_less_int @ zero_zero_int @ ( semiri1621563631at_int @ N ) )
    <=> ( ord_less_nat @ zero_zero_nat @ N ) ) )).

thf(fact_224_one__neq__zero,axiom,(
    one_one_real != zero_zero_real )).

thf(fact_225_one__neq__zero,axiom,(
    one_one_nat != zero_zero_nat )).

thf(fact_226_one__neq__zero,axiom,(
    one_one_int != zero_zero_int )).

thf(fact_227_zero__neq__one,axiom,(
    zero_zero_real != one_one_real )).

thf(fact_228_zero__neq__one,axiom,(
    zero_zero_nat != one_one_nat )).

thf(fact_229_zero__neq__one,axiom,(
    zero_zero_int != one_one_int )).

thf(fact_230_field__power__not__zero,axiom,(
    ! [N_27: nat,A_75: real] :
      ( ( A_75 != zero_zero_real )
     => ( ( power_power_real @ A_75 @ N_27 )
       != zero_zero_real ) ) )).

thf(fact_231_field__power__not__zero,axiom,(
    ! [N_27: nat,A_75: int] :
      ( ( A_75 != zero_zero_int )
     => ( ( power_power_int @ A_75 @ N_27 )
       != zero_zero_int ) ) )).

thf(fact_232_power__one,axiom,(
    ! [N_26: nat] :
      ( ( power_power_real @ one_one_real @ N_26 )
      = one_one_real ) )).

thf(fact_233_power__one,axiom,(
    ! [N_26: nat] :
      ( ( power_power_nat @ one_one_nat @ N_26 )
      = one_one_nat ) )).

thf(fact_234_power__one,axiom,(
    ! [N_26: nat] :
      ( ( power_power_int @ one_one_int @ N_26 )
      = one_one_int ) )).

thf(fact_235_of__nat__less__iff,axiom,(
    ! [M_12: nat,N_25: nat] :
      ( ( ord_less_real @ ( semiri132038758t_real @ M_12 ) @ ( semiri132038758t_real @ N_25 ) )
    <=> ( ord_less_nat @ M_12 @ N_25 ) ) )).

thf(fact_236_of__nat__less__iff,axiom,(
    ! [M_12: nat,N_25: nat] :
      ( ( ord_less_nat @ ( semiri984289939at_nat @ M_12 ) @ ( semiri984289939at_nat @ N_25 ) )
    <=> ( ord_less_nat @ M_12 @ N_25 ) ) )).

thf(fact_237_of__nat__less__iff,axiom,(
    ! [M_12: nat,N_25: nat] :
      ( ( ord_less_int @ ( semiri1621563631at_int @ M_12 ) @ ( semiri1621563631at_int @ N_25 ) )
    <=> ( ord_less_nat @ M_12 @ N_25 ) ) )).

thf(fact_238_less__imp__of__nat__less,axiom,(
    ! [M_11: nat,N_24: nat] :
      ( ( ord_less_nat @ M_11 @ N_24 )
     => ( ord_less_real @ ( semiri132038758t_real @ M_11 ) @ ( semiri132038758t_real @ N_24 ) ) ) )).

thf(fact_239_less__imp__of__nat__less,axiom,(
    ! [M_11: nat,N_24: nat] :
      ( ( ord_less_nat @ M_11 @ N_24 )
     => ( ord_less_nat @ ( semiri984289939at_nat @ M_11 ) @ ( semiri984289939at_nat @ N_24 ) ) ) )).

thf(fact_240_less__imp__of__nat__less,axiom,(
    ! [M_11: nat,N_24: nat] :
      ( ( ord_less_nat @ M_11 @ N_24 )
     => ( ord_less_int @ ( semiri1621563631at_int @ M_11 ) @ ( semiri1621563631at_int @ N_24 ) ) ) )).

thf(fact_241_of__nat__less__imp__less,axiom,(
    ! [M_10: nat,N_23: nat] :
      ( ( ord_less_real @ ( semiri132038758t_real @ M_10 ) @ ( semiri132038758t_real @ N_23 ) )
     => ( ord_less_nat @ M_10 @ N_23 ) ) )).

thf(fact_242_of__nat__less__imp__less,axiom,(
    ! [M_10: nat,N_23: nat] :
      ( ( ord_less_nat @ ( semiri984289939at_nat @ M_10 ) @ ( semiri984289939at_nat @ N_23 ) )
     => ( ord_less_nat @ M_10 @ N_23 ) ) )).

thf(fact_243_of__nat__less__imp__less,axiom,(
    ! [M_10: nat,N_23: nat] :
      ( ( ord_less_int @ ( semiri1621563631at_int @ M_10 ) @ ( semiri1621563631at_int @ N_23 ) )
     => ( ord_less_nat @ M_10 @ N_23 ) ) )).

thf(fact_244_of__nat__add,axiom,(
    ! [M_9: nat,N_22: nat] :
      ( ( semiri132038758t_real @ ( plus_plus_nat @ M_9 @ N_22 ) )
      = ( plus_plus_real @ ( semiri132038758t_real @ M_9 ) @ ( semiri132038758t_real @ N_22 ) ) ) )).

thf(fact_245_of__nat__add,axiom,(
    ! [M_9: nat,N_22: nat] :
      ( ( semiri984289939at_nat @ ( plus_plus_nat @ M_9 @ N_22 ) )
      = ( plus_plus_nat @ ( semiri984289939at_nat @ M_9 ) @ ( semiri984289939at_nat @ N_22 ) ) ) )).

thf(fact_246_of__nat__add,axiom,(
    ! [M_9: nat,N_22: nat] :
      ( ( semiri1621563631at_int @ ( plus_plus_nat @ M_9 @ N_22 ) )
      = ( plus_plus_int @ ( semiri1621563631at_int @ M_9 ) @ ( semiri1621563631at_int @ N_22 ) ) ) )).

thf(fact_247_of__nat__1,axiom,
    ( ( semiri132038758t_real @ one_one_nat )
    = one_one_real )).

thf(fact_248_of__nat__1,axiom,
    ( ( semiri984289939at_nat @ one_one_nat )
    = one_one_nat )).

thf(fact_249_of__nat__1,axiom,
    ( ( semiri1621563631at_int @ one_one_nat )
    = one_one_int )).

thf(fact_250_of__nat__power,axiom,(
    ! [M_8: nat,N_21: nat] :
      ( ( semiri132038758t_real @ ( power_power_nat @ M_8 @ N_21 ) )
      = ( power_power_real @ ( semiri132038758t_real @ M_8 ) @ N_21 ) ) )).

thf(fact_251_of__nat__power,axiom,(
    ! [M_8: nat,N_21: nat] :
      ( ( semiri984289939at_nat @ ( power_power_nat @ M_8 @ N_21 ) )
      = ( power_power_nat @ ( semiri984289939at_nat @ M_8 ) @ N_21 ) ) )).

thf(fact_252_of__nat__power,axiom,(
    ! [M_8: nat,N_21: nat] :
      ( ( semiri1621563631at_int @ ( power_power_nat @ M_8 @ N_21 ) )
      = ( power_power_int @ ( semiri1621563631at_int @ M_8 ) @ N_21 ) ) )).

thf(fact_253_transfer__int__nat__numerals_I2_J,axiom,
    ( one_one_int
    = ( semiri1621563631at_int @ one_one_nat ) )).

thf(fact_254_Nat__Transfer_Otransfer__int__nat__functions_I1_J,axiom,(
    ! [X: nat,Y: nat] :
      ( ( plus_plus_int @ ( semiri1621563631at_int @ X ) @ ( semiri1621563631at_int @ Y ) )
      = ( semiri1621563631at_int @ ( plus_plus_nat @ X @ Y ) ) ) )).

thf(fact_255_Nat__Transfer_Otransfer__int__nat__functions_I4_J,axiom,(
    ! [X: nat,N: nat] :
      ( ( power_power_int @ ( semiri1621563631at_int @ X ) @ N )
      = ( semiri1621563631at_int @ ( power_power_nat @ X @ N ) ) ) )).

thf(fact_256_pos__add__strict,axiom,(
    ! [B_49: real,C_36: real,A_74: real] :
      ( ( ord_less_real @ zero_zero_real @ A_74 )
     => ( ( ord_less_real @ B_49 @ C_36 )
       => ( ord_less_real @ B_49 @ ( plus_plus_real @ A_74 @ C_36 ) ) ) ) )).

thf(fact_257_pos__add__strict,axiom,(
    ! [B_49: nat,C_36: nat,A_74: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A_74 )
     => ( ( ord_less_nat @ B_49 @ C_36 )
       => ( ord_less_nat @ B_49 @ ( plus_plus_nat @ A_74 @ C_36 ) ) ) ) )).

thf(fact_258_pos__add__strict,axiom,(
    ! [B_49: int,C_36: int,A_74: int] :
      ( ( ord_less_int @ zero_zero_int @ A_74 )
     => ( ( ord_less_int @ B_49 @ C_36 )
       => ( ord_less_int @ B_49 @ ( plus_plus_int @ A_74 @ C_36 ) ) ) ) )).

thf(fact_259_not__one__less__zero,axiom,(
    ~ ( ord_less_real @ one_one_real @ zero_zero_real ) )).

thf(fact_260_not__one__less__zero,axiom,(
    ~ ( ord_less_nat @ one_one_nat @ zero_zero_nat ) )).

thf(fact_261_not__one__less__zero,axiom,(
    ~ ( ord_less_int @ one_one_int @ zero_zero_int ) )).

thf(fact_262_zero__less__one,axiom,
    ( ord_less_real @ zero_zero_real @ one_one_real )).

thf(fact_263_zero__less__one,axiom,
    ( ord_less_nat @ zero_zero_nat @ one_one_nat )).

thf(fact_264_zero__less__one,axiom,
    ( ord_less_int @ zero_zero_int @ one_one_int )).

thf(fact_265_zero__less__power,axiom,(
    ! [N_20: nat,A_73: real] :
      ( ( ord_less_real @ zero_zero_real @ A_73 )
     => ( ord_less_real @ zero_zero_real @ ( power_power_real @ A_73 @ N_20 ) ) ) )).

thf(fact_266_zero__less__power,axiom,(
    ! [N_20: nat,A_73: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A_73 )
     => ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ A_73 @ N_20 ) ) ) )).

thf(fact_267_zero__less__power,axiom,(
    ! [N_20: nat,A_73: int] :
      ( ( ord_less_int @ zero_zero_int @ A_73 )
     => ( ord_less_int @ zero_zero_int @ ( power_power_int @ A_73 @ N_20 ) ) ) )).

thf(fact_268_less__add__one,axiom,(
    ! [A_72: real] :
      ( ord_less_real @ A_72 @ ( plus_plus_real @ A_72 @ one_one_real ) ) )).

thf(fact_269_less__add__one,axiom,(
    ! [A_72: nat] :
      ( ord_less_nat @ A_72 @ ( plus_plus_nat @ A_72 @ one_one_nat ) ) )).

thf(fact_270_less__add__one,axiom,(
    ! [A_72: int] :
      ( ord_less_int @ A_72 @ ( plus_plus_int @ A_72 @ one_one_int ) ) )).

thf(fact_271_power__inject__exp,axiom,(
    ! [M_7: nat,N_19: nat,A_71: real] :
      ( ( ord_less_real @ one_one_real @ A_71 )
     => ( ( ( power_power_real @ A_71 @ M_7 )
          = ( power_power_real @ A_71 @ N_19 ) )
      <=> ( M_7 = N_19 ) ) ) )).

thf(fact_272_power__inject__exp,axiom,(
    ! [M_7: nat,N_19: nat,A_71: nat] :
      ( ( ord_less_nat @ one_one_nat @ A_71 )
     => ( ( ( power_power_nat @ A_71 @ M_7 )
          = ( power_power_nat @ A_71 @ N_19 ) )
      <=> ( M_7 = N_19 ) ) ) )).

thf(fact_273_power__inject__exp,axiom,(
    ! [M_7: nat,N_19: nat,A_71: int] :
      ( ( ord_less_int @ one_one_int @ A_71 )
     => ( ( ( power_power_int @ A_71 @ M_7 )
          = ( power_power_int @ A_71 @ N_19 ) )
      <=> ( M_7 = N_19 ) ) ) )).

thf(fact_274_power__strict__increasing__iff,axiom,(
    ! [X_24: nat,Y_19: nat,B_48: real] :
      ( ( ord_less_real @ one_one_real @ B_48 )
     => ( ( ord_less_real @ ( power_power_real @ B_48 @ X_24 ) @ ( power_power_real @ B_48 @ Y_19 ) )
      <=> ( ord_less_nat @ X_24 @ Y_19 ) ) ) )).

thf(fact_275_power__strict__increasing__iff,axiom,(
    ! [X_24: nat,Y_19: nat,B_48: nat] :
      ( ( ord_less_nat @ one_one_nat @ B_48 )
     => ( ( ord_less_nat @ ( power_power_nat @ B_48 @ X_24 ) @ ( power_power_nat @ B_48 @ Y_19 ) )
      <=> ( ord_less_nat @ X_24 @ Y_19 ) ) ) )).

thf(fact_276_power__strict__increasing__iff,axiom,(
    ! [X_24: nat,Y_19: nat,B_48: int] :
      ( ( ord_less_int @ one_one_int @ B_48 )
     => ( ( ord_less_int @ ( power_power_int @ B_48 @ X_24 ) @ ( power_power_int @ B_48 @ Y_19 ) )
      <=> ( ord_less_nat @ X_24 @ Y_19 ) ) ) )).

thf(fact_277_power__less__imp__less__exp,axiom,(
    ! [M_6: nat,N_18: nat,A_70: real] :
      ( ( ord_less_real @ one_one_real @ A_70 )
     => ( ( ord_less_real @ ( power_power_real @ A_70 @ M_6 ) @ ( power_power_real @ A_70 @ N_18 ) )
       => ( ord_less_nat @ M_6 @ N_18 ) ) ) )).

thf(fact_278_power__less__imp__less__exp,axiom,(
    ! [M_6: nat,N_18: nat,A_70: nat] :
      ( ( ord_less_nat @ one_one_nat @ A_70 )
     => ( ( ord_less_nat @ ( power_power_nat @ A_70 @ M_6 ) @ ( power_power_nat @ A_70 @ N_18 ) )
       => ( ord_less_nat @ M_6 @ N_18 ) ) ) )).

thf(fact_279_power__less__imp__less__exp,axiom,(
    ! [M_6: nat,N_18: nat,A_70: int] :
      ( ( ord_less_int @ one_one_int @ A_70 )
     => ( ( ord_less_int @ ( power_power_int @ A_70 @ M_6 ) @ ( power_power_int @ A_70 @ N_18 ) )
       => ( ord_less_nat @ M_6 @ N_18 ) ) ) )).

thf(fact_280_power__strict__increasing,axiom,(
    ! [A_69: real,N_17: nat,N_16: nat] :
      ( ( ord_less_nat @ N_17 @ N_16 )
     => ( ( ord_less_real @ one_one_real @ A_69 )
       => ( ord_less_real @ ( power_power_real @ A_69 @ N_17 ) @ ( power_power_real @ A_69 @ N_16 ) ) ) ) )).

thf(fact_281_power__strict__increasing,axiom,(
    ! [A_69: nat,N_17: nat,N_16: nat] :
      ( ( ord_less_nat @ N_17 @ N_16 )
     => ( ( ord_less_nat @ one_one_nat @ A_69 )
       => ( ord_less_nat @ ( power_power_nat @ A_69 @ N_17 ) @ ( power_power_nat @ A_69 @ N_16 ) ) ) ) )).

thf(fact_282_power__strict__increasing,axiom,(
    ! [A_69: int,N_17: nat,N_16: nat] :
      ( ( ord_less_nat @ N_17 @ N_16 )
     => ( ( ord_less_int @ one_one_int @ A_69 )
       => ( ord_less_int @ ( power_power_int @ A_69 @ N_17 ) @ ( power_power_int @ A_69 @ N_16 ) ) ) ) )).

thf(fact_283_power__eq__0__iff,axiom,(
    ! [A_68: real,N_15: nat] :
      ( ( ( power_power_real @ A_68 @ N_15 )
        = zero_zero_real )
    <=> ( ( A_68 = zero_zero_real )
        & ( N_15 != zero_zero_nat ) ) ) )).

thf(fact_284_power__eq__0__iff,axiom,(
    ! [A_68: nat,N_15: nat] :
      ( ( ( power_power_nat @ A_68 @ N_15 )
        = zero_zero_nat )
    <=> ( ( A_68 = zero_zero_nat )
        & ( N_15 != zero_zero_nat ) ) ) )).

thf(fact_285_power__eq__0__iff,axiom,(
    ! [A_68: int,N_15: nat] :
      ( ( ( power_power_int @ A_68 @ N_15 )
        = zero_zero_int )
    <=> ( ( A_68 = zero_zero_int )
        & ( N_15 != zero_zero_nat ) ) ) )).

thf(fact_286_of__nat__less__0__iff,axiom,(
    ! [M_5: nat] :
      ~ ( ord_less_real @ ( semiri132038758t_real @ M_5 ) @ zero_zero_real ) )).

thf(fact_287_of__nat__less__0__iff,axiom,(
    ! [M_5: nat] :
      ~ ( ord_less_nat @ ( semiri984289939at_nat @ M_5 ) @ zero_zero_nat ) )).

thf(fact_288_of__nat__less__0__iff,axiom,(
    ! [M_5: nat] :
      ~ ( ord_less_int @ ( semiri1621563631at_int @ M_5 ) @ zero_zero_int ) )).

thf(fact_289_power__0,axiom,(
    ! [A_67: real] :
      ( ( power_power_real @ A_67 @ zero_zero_nat )
      = one_one_real ) )).

thf(fact_290_power__0,axiom,(
    ! [A_67: nat] :
      ( ( power_power_nat @ A_67 @ zero_zero_nat )
      = one_one_nat ) )).

thf(fact_291_power__0,axiom,(
    ! [A_67: int] :
      ( ( power_power_int @ A_67 @ zero_zero_nat )
      = one_one_int ) )).

thf(fact_292_of__nat__0,axiom,
    ( ( semiri132038758t_real @ zero_zero_nat )
    = zero_zero_real )).

thf(fact_293_of__nat__0,axiom,
    ( ( semiri984289939at_nat @ zero_zero_nat )
    = zero_zero_nat )).

thf(fact_294_of__nat__0,axiom,
    ( ( semiri1621563631at_int @ zero_zero_nat )
    = zero_zero_int )).

thf(fact_295_transfer__int__nat__numerals_I1_J,axiom,
    ( zero_zero_int
    = ( semiri1621563631at_int @ zero_zero_nat ) )).

thf(fact_296_pos2,axiom,
    ( ord_less_nat @ zero_zero_nat @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_297_zero__less__imp__eq__int,axiom,(
    ! [K: int] :
      ( ( ord_less_int @ zero_zero_int @ K )
     => ? [N_1: nat] :
          ( ( ord_less_nat @ zero_zero_nat @ N_1 )
          & ( K
            = ( semiri1621563631at_int @ N_1 ) ) ) ) )).

thf(fact_298_less__imp__add__positive,axiom,(
    ! [I: nat,J: nat] :
      ( ( ord_less_nat @ I @ J )
     => ? [K_1: nat] :
          ( ( ord_less_nat @ zero_zero_nat @ K_1 )
          & ( ( plus_plus_nat @ I @ K_1 )
            = J ) ) ) )).

thf(fact_299_exp__eq__1,axiom,(
    ! [X: nat,N: nat] :
      ( ( ( power_power_nat @ X @ N )
        = one_one_nat )
    <=> ( ( X = one_one_nat )
        | ( N = zero_zero_nat ) ) ) )).

thf(fact_300_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,(
    ! [X_23: real] :
      ( ( power_power_real @ X_23 @ zero_zero_nat )
      = one_one_real ) )).

thf(fact_301_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,(
    ! [X_23: nat] :
      ( ( power_power_nat @ X_23 @ zero_zero_nat )
      = one_one_nat ) )).

thf(fact_302_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,(
    ! [X_23: int] :
      ( ( power_power_int @ X_23 @ zero_zero_nat )
      = one_one_int ) )).

thf(fact_303_zero__less__double__add__iff__zero__less__single__add,axiom,(
    ! [A_66: real] :
      ( ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ A_66 @ A_66 ) )
    <=> ( ord_less_real @ zero_zero_real @ A_66 ) ) )).

thf(fact_304_zero__less__double__add__iff__zero__less__single__add,axiom,(
    ! [A_66: int] :
      ( ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ A_66 @ A_66 ) )
    <=> ( ord_less_int @ zero_zero_int @ A_66 ) ) )).

thf(fact_305_double__add__less__zero__iff__single__add__less__zero,axiom,(
    ! [A_65: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A_65 @ A_65 ) @ zero_zero_real )
    <=> ( ord_less_real @ A_65 @ zero_zero_real ) ) )).

thf(fact_306_double__add__less__zero__iff__single__add__less__zero,axiom,(
    ! [A_65: int] :
      ( ( ord_less_int @ ( plus_plus_int @ A_65 @ A_65 ) @ zero_zero_int )
    <=> ( ord_less_int @ A_65 @ zero_zero_int ) ) )).

thf(fact_307_zero__reorient,axiom,(
    ! [X_22: real] :
      ( ( zero_zero_real = X_22 )
    <=> ( X_22 = zero_zero_real ) ) )).

thf(fact_308_zero__reorient,axiom,(
    ! [X_22: nat] :
      ( ( zero_zero_nat = X_22 )
    <=> ( X_22 = zero_zero_nat ) ) )).

thf(fact_309_zero__reorient,axiom,(
    ! [X_22: int] :
      ( ( zero_zero_int = X_22 )
    <=> ( X_22 = zero_zero_int ) ) )).

thf(fact_310_add__right__imp__eq,axiom,(
    ! [B_47: real,A_64: real,C_35: real] :
      ( ( ( plus_plus_real @ B_47 @ A_64 )
        = ( plus_plus_real @ C_35 @ A_64 ) )
     => ( B_47 = C_35 ) ) )).

thf(fact_311_add__right__imp__eq,axiom,(
    ! [B_47: nat,A_64: nat,C_35: nat] :
      ( ( ( plus_plus_nat @ B_47 @ A_64 )
        = ( plus_plus_nat @ C_35 @ A_64 ) )
     => ( B_47 = C_35 ) ) )).

thf(fact_312_add__right__imp__eq,axiom,(
    ! [B_47: int,A_64: int,C_35: int] :
      ( ( ( plus_plus_int @ B_47 @ A_64 )
        = ( plus_plus_int @ C_35 @ A_64 ) )
     => ( B_47 = C_35 ) ) )).

thf(fact_313_add__imp__eq,axiom,(
    ! [A_63: real,B_46: real,C_34: real] :
      ( ( ( plus_plus_real @ A_63 @ B_46 )
        = ( plus_plus_real @ A_63 @ C_34 ) )
     => ( B_46 = C_34 ) ) )).

thf(fact_314_add__imp__eq,axiom,(
    ! [A_63: nat,B_46: nat,C_34: nat] :
      ( ( ( plus_plus_nat @ A_63 @ B_46 )
        = ( plus_plus_nat @ A_63 @ C_34 ) )
     => ( B_46 = C_34 ) ) )).

thf(fact_315_add__imp__eq,axiom,(
    ! [A_63: int,B_46: int,C_34: int] :
      ( ( ( plus_plus_int @ A_63 @ B_46 )
        = ( plus_plus_int @ A_63 @ C_34 ) )
     => ( B_46 = C_34 ) ) )).

thf(fact_316_add__left__imp__eq,axiom,(
    ! [A_62: real,B_45: real,C_33: real] :
      ( ( ( plus_plus_real @ A_62 @ B_45 )
        = ( plus_plus_real @ A_62 @ C_33 ) )
     => ( B_45 = C_33 ) ) )).

thf(fact_317_add__left__imp__eq,axiom,(
    ! [A_62: nat,B_45: nat,C_33: nat] :
      ( ( ( plus_plus_nat @ A_62 @ B_45 )
        = ( plus_plus_nat @ A_62 @ C_33 ) )
     => ( B_45 = C_33 ) ) )).

thf(fact_318_add__left__imp__eq,axiom,(
    ! [A_62: int,B_45: int,C_33: int] :
      ( ( ( plus_plus_int @ A_62 @ B_45 )
        = ( plus_plus_int @ A_62 @ C_33 ) )
     => ( B_45 = C_33 ) ) )).

thf(fact_319_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,(
    ! [A_61: real,B_44: real,C_32: real,D_6: real] :
      ( ( plus_plus_real @ ( plus_plus_real @ A_61 @ B_44 ) @ ( plus_plus_real @ C_32 @ D_6 ) )
      = ( plus_plus_real @ ( plus_plus_real @ A_61 @ C_32 ) @ ( plus_plus_real @ B_44 @ D_6 ) ) ) )).

thf(fact_320_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,(
    ! [A_61: nat,B_44: nat,C_32: nat,D_6: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A_61 @ B_44 ) @ ( plus_plus_nat @ C_32 @ D_6 ) )
      = ( plus_plus_nat @ ( plus_plus_nat @ A_61 @ C_32 ) @ ( plus_plus_nat @ B_44 @ D_6 ) ) ) )).

thf(fact_321_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,(
    ! [A_61: int,B_44: int,C_32: int,D_6: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ A_61 @ B_44 ) @ ( plus_plus_int @ C_32 @ D_6 ) )
      = ( plus_plus_int @ ( plus_plus_int @ A_61 @ C_32 ) @ ( plus_plus_int @ B_44 @ D_6 ) ) ) )).

thf(fact_322_add__right__cancel,axiom,(
    ! [B_43: real,A_60: real,C_31: real] :
      ( ( ( plus_plus_real @ B_43 @ A_60 )
        = ( plus_plus_real @ C_31 @ A_60 ) )
    <=> ( B_43 = C_31 ) ) )).

thf(fact_323_add__right__cancel,axiom,(
    ! [B_43: nat,A_60: nat,C_31: nat] :
      ( ( ( plus_plus_nat @ B_43 @ A_60 )
        = ( plus_plus_nat @ C_31 @ A_60 ) )
    <=> ( B_43 = C_31 ) ) )).

thf(fact_324_add__right__cancel,axiom,(
    ! [B_43: int,A_60: int,C_31: int] :
      ( ( ( plus_plus_int @ B_43 @ A_60 )
        = ( plus_plus_int @ C_31 @ A_60 ) )
    <=> ( B_43 = C_31 ) ) )).

thf(fact_325_add__left__cancel,axiom,(
    ! [A_59: real,B_42: real,C_30: real] :
      ( ( ( plus_plus_real @ A_59 @ B_42 )
        = ( plus_plus_real @ A_59 @ C_30 ) )
    <=> ( B_42 = C_30 ) ) )).

thf(fact_326_add__left__cancel,axiom,(
    ! [A_59: nat,B_42: nat,C_30: nat] :
      ( ( ( plus_plus_nat @ A_59 @ B_42 )
        = ( plus_plus_nat @ A_59 @ C_30 ) )
    <=> ( B_42 = C_30 ) ) )).

thf(fact_327_add__left__cancel,axiom,(
    ! [A_59: int,B_42: int,C_30: int] :
      ( ( ( plus_plus_int @ A_59 @ B_42 )
        = ( plus_plus_int @ A_59 @ C_30 ) )
    <=> ( B_42 = C_30 ) ) )).

thf(fact_328_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,(
    ! [A_58: real,B_41: real,C_29: real] :
      ( ( plus_plus_real @ ( plus_plus_real @ A_58 @ B_41 ) @ C_29 )
      = ( plus_plus_real @ ( plus_plus_real @ A_58 @ C_29 ) @ B_41 ) ) )).

thf(fact_329_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,(
    ! [A_58: nat,B_41: nat,C_29: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A_58 @ B_41 ) @ C_29 )
      = ( plus_plus_nat @ ( plus_plus_nat @ A_58 @ C_29 ) @ B_41 ) ) )).

thf(fact_330_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,(
    ! [A_58: int,B_41: int,C_29: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ A_58 @ B_41 ) @ C_29 )
      = ( plus_plus_int @ ( plus_plus_int @ A_58 @ C_29 ) @ B_41 ) ) )).

thf(fact_331_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,(
    ! [A_57: real,B_40: real,C_28: real] :
      ( ( plus_plus_real @ ( plus_plus_real @ A_57 @ B_40 ) @ C_28 )
      = ( plus_plus_real @ A_57 @ ( plus_plus_real @ B_40 @ C_28 ) ) ) )).

thf(fact_332_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,(
    ! [A_57: nat,B_40: nat,C_28: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A_57 @ B_40 ) @ C_28 )
      = ( plus_plus_nat @ A_57 @ ( plus_plus_nat @ B_40 @ C_28 ) ) ) )).

thf(fact_333_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,(
    ! [A_57: int,B_40: int,C_28: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ A_57 @ B_40 ) @ C_28 )
      = ( plus_plus_int @ A_57 @ ( plus_plus_int @ B_40 @ C_28 ) ) ) )).

thf(fact_334_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,(
    ! [A_56: real,B_39: real,C_27: real] :
      ( ( plus_plus_real @ ( plus_plus_real @ A_56 @ B_39 ) @ C_27 )
      = ( plus_plus_real @ A_56 @ ( plus_plus_real @ B_39 @ C_27 ) ) ) )).

thf(fact_335_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,(
    ! [A_56: nat,B_39: nat,C_27: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A_56 @ B_39 ) @ C_27 )
      = ( plus_plus_nat @ A_56 @ ( plus_plus_nat @ B_39 @ C_27 ) ) ) )).

thf(fact_336_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,(
    ! [A_56: int,B_39: int,C_27: int] :
      ( ( plus_plus_int @ ( plus_plus_int @ A_56 @ B_39 ) @ C_27 )
      = ( plus_plus_int @ A_56 @ ( plus_plus_int @ B_39 @ C_27 ) ) ) )).

thf(fact_337_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,(
    ! [A_55: real,C_26: real,D_5: real] :
      ( ( plus_plus_real @ A_55 @ ( plus_plus_real @ C_26 @ D_5 ) )
      = ( plus_plus_real @ ( plus_plus_real @ A_55 @ C_26 ) @ D_5 ) ) )).

thf(fact_338_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,(
    ! [A_55: nat,C_26: nat,D_5: nat] :
      ( ( plus_plus_nat @ A_55 @ ( plus_plus_nat @ C_26 @ D_5 ) )
      = ( plus_plus_nat @ ( plus_plus_nat @ A_55 @ C_26 ) @ D_5 ) ) )).

thf(fact_339_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,(
    ! [A_55: int,C_26: int,D_5: int] :
      ( ( plus_plus_int @ A_55 @ ( plus_plus_int @ C_26 @ D_5 ) )
      = ( plus_plus_int @ ( plus_plus_int @ A_55 @ C_26 ) @ D_5 ) ) )).

thf(fact_340_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,(
    ! [A_54: real,C_25: real,D_4: real] :
      ( ( plus_plus_real @ A_54 @ ( plus_plus_real @ C_25 @ D_4 ) )
      = ( plus_plus_real @ C_25 @ ( plus_plus_real @ A_54 @ D_4 ) ) ) )).

thf(fact_341_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,(
    ! [A_54: nat,C_25: nat,D_4: nat] :
      ( ( plus_plus_nat @ A_54 @ ( plus_plus_nat @ C_25 @ D_4 ) )
      = ( plus_plus_nat @ C_25 @ ( plus_plus_nat @ A_54 @ D_4 ) ) ) )).

thf(fact_342_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,(
    ! [A_54: int,C_25: int,D_4: int] :
      ( ( plus_plus_int @ A_54 @ ( plus_plus_int @ C_25 @ D_4 ) )
      = ( plus_plus_int @ C_25 @ ( plus_plus_int @ A_54 @ D_4 ) ) ) )).

thf(fact_343_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,(
    ! [A_53: real,C_24: real] :
      ( ( plus_plus_real @ A_53 @ C_24 )
      = ( plus_plus_real @ C_24 @ A_53 ) ) )).

thf(fact_344_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,(
    ! [A_53: nat,C_24: nat] :
      ( ( plus_plus_nat @ A_53 @ C_24 )
      = ( plus_plus_nat @ C_24 @ A_53 ) ) )).

thf(fact_345_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,(
    ! [A_53: int,C_24: int] :
      ( ( plus_plus_int @ A_53 @ C_24 )
      = ( plus_plus_int @ C_24 @ A_53 ) ) )).

thf(fact_346_one__reorient,axiom,(
    ! [X_21: real] :
      ( ( one_one_real = X_21 )
    <=> ( X_21 = one_one_real ) ) )).

thf(fact_347_one__reorient,axiom,(
    ! [X_21: nat] :
      ( ( one_one_nat = X_21 )
    <=> ( X_21 = one_one_nat ) ) )).

thf(fact_348_one__reorient,axiom,(
    ! [X_21: int] :
      ( ( one_one_int = X_21 )
    <=> ( X_21 = one_one_int ) ) )).

thf(fact_349_add__0__iff,axiom,(
    ! [B_38: real,A_52: real] :
      ( ( B_38
        = ( plus_plus_real @ B_38 @ A_52 ) )
    <=> ( A_52 = zero_zero_real ) ) )).

thf(fact_350_add__0__iff,axiom,(
    ! [B_38: nat,A_52: nat] :
      ( ( B_38
        = ( plus_plus_nat @ B_38 @ A_52 ) )
    <=> ( A_52 = zero_zero_nat ) ) )).

thf(fact_351_add__0__iff,axiom,(
    ! [B_38: int,A_52: int] :
      ( ( B_38
        = ( plus_plus_int @ B_38 @ A_52 ) )
    <=> ( A_52 = zero_zero_int ) ) )).

thf(fact_352_add_Ocomm__neutral,axiom,(
    ! [A_51: real] :
      ( ( plus_plus_real @ A_51 @ zero_zero_real )
      = A_51 ) )).

thf(fact_353_add_Ocomm__neutral,axiom,(
    ! [A_51: nat] :
      ( ( plus_plus_nat @ A_51 @ zero_zero_nat )
      = A_51 ) )).

thf(fact_354_add_Ocomm__neutral,axiom,(
    ! [A_51: int] :
      ( ( plus_plus_int @ A_51 @ zero_zero_int )
      = A_51 ) )).

thf(fact_355_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,(
    ! [A_50: real] :
      ( ( plus_plus_real @ A_50 @ zero_zero_real )
      = A_50 ) )).

thf(fact_356_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,(
    ! [A_50: nat] :
      ( ( plus_plus_nat @ A_50 @ zero_zero_nat )
      = A_50 ) )).

thf(fact_357_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,(
    ! [A_50: int] :
      ( ( plus_plus_int @ A_50 @ zero_zero_int )
      = A_50 ) )).

thf(fact_358_add__0__right,axiom,(
    ! [A_49: real] :
      ( ( plus_plus_real @ A_49 @ zero_zero_real )
      = A_49 ) )).

thf(fact_359_add__0__right,axiom,(
    ! [A_49: nat] :
      ( ( plus_plus_nat @ A_49 @ zero_zero_nat )
      = A_49 ) )).

thf(fact_360_add__0__right,axiom,(
    ! [A_49: int] :
      ( ( plus_plus_int @ A_49 @ zero_zero_int )
      = A_49 ) )).

thf(fact_361_double__zero__sym,axiom,(
    ! [A_48: real] :
      ( ( zero_zero_real
        = ( plus_plus_real @ A_48 @ A_48 ) )
    <=> ( A_48 = zero_zero_real ) ) )).

thf(fact_362_double__zero__sym,axiom,(
    ! [A_48: int] :
      ( ( zero_zero_int
        = ( plus_plus_int @ A_48 @ A_48 ) )
    <=> ( A_48 = zero_zero_int ) ) )).

thf(fact_363_add__0,axiom,(
    ! [A_47: real] :
      ( ( plus_plus_real @ zero_zero_real @ A_47 )
      = A_47 ) )).

thf(fact_364_add__0,axiom,(
    ! [A_47: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A_47 )
      = A_47 ) )).

thf(fact_365_add__0,axiom,(
    ! [A_47: int] :
      ( ( plus_plus_int @ zero_zero_int @ A_47 )
      = A_47 ) )).

thf(fact_366_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,(
    ! [A_46: real] :
      ( ( plus_plus_real @ zero_zero_real @ A_46 )
      = A_46 ) )).

thf(fact_367_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,(
    ! [A_46: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A_46 )
      = A_46 ) )).

thf(fact_368_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,(
    ! [A_46: int] :
      ( ( plus_plus_int @ zero_zero_int @ A_46 )
      = A_46 ) )).

thf(fact_369_add__0__left,axiom,(
    ! [A_45: real] :
      ( ( plus_plus_real @ zero_zero_real @ A_45 )
      = A_45 ) )).

thf(fact_370_add__0__left,axiom,(
    ! [A_45: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A_45 )
      = A_45 ) )).

thf(fact_371_add__0__left,axiom,(
    ! [A_45: int] :
      ( ( plus_plus_int @ zero_zero_int @ A_45 )
      = A_45 ) )).

thf(fact_372_add__less__imp__less__left,axiom,(
    ! [C_23: real,A_44: real,B_37: real] :
      ( ( ord_less_real @ ( plus_plus_real @ C_23 @ A_44 ) @ ( plus_plus_real @ C_23 @ B_37 ) )
     => ( ord_less_real @ A_44 @ B_37 ) ) )).

thf(fact_373_add__less__imp__less__left,axiom,(
    ! [C_23: nat,A_44: nat,B_37: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C_23 @ A_44 ) @ ( plus_plus_nat @ C_23 @ B_37 ) )
     => ( ord_less_nat @ A_44 @ B_37 ) ) )).

thf(fact_374_add__less__imp__less__left,axiom,(
    ! [C_23: int,A_44: int,B_37: int] :
      ( ( ord_less_int @ ( plus_plus_int @ C_23 @ A_44 ) @ ( plus_plus_int @ C_23 @ B_37 ) )
     => ( ord_less_int @ A_44 @ B_37 ) ) )).

thf(fact_375_add__less__imp__less__right,axiom,(
    ! [A_43: real,C_22: real,B_36: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A_43 @ C_22 ) @ ( plus_plus_real @ B_36 @ C_22 ) )
     => ( ord_less_real @ A_43 @ B_36 ) ) )).

thf(fact_376_add__less__imp__less__right,axiom,(
    ! [A_43: nat,C_22: nat,B_36: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A_43 @ C_22 ) @ ( plus_plus_nat @ B_36 @ C_22 ) )
     => ( ord_less_nat @ A_43 @ B_36 ) ) )).

thf(fact_377_add__less__imp__less__right,axiom,(
    ! [A_43: int,C_22: int,B_36: int] :
      ( ( ord_less_int @ ( plus_plus_int @ A_43 @ C_22 ) @ ( plus_plus_int @ B_36 @ C_22 ) )
     => ( ord_less_int @ A_43 @ B_36 ) ) )).

thf(fact_378_add__strict__mono,axiom,(
    ! [C_21: real,D_3: real,A_42: real,B_35: real] :
      ( ( ord_less_real @ A_42 @ B_35 )
     => ( ( ord_less_real @ C_21 @ D_3 )
       => ( ord_less_real @ ( plus_plus_real @ A_42 @ C_21 ) @ ( plus_plus_real @ B_35 @ D_3 ) ) ) ) )).

thf(fact_379_add__strict__mono,axiom,(
    ! [C_21: nat,D_3: nat,A_42: nat,B_35: nat] :
      ( ( ord_less_nat @ A_42 @ B_35 )
     => ( ( ord_less_nat @ C_21 @ D_3 )
       => ( ord_less_nat @ ( plus_plus_nat @ A_42 @ C_21 ) @ ( plus_plus_nat @ B_35 @ D_3 ) ) ) ) )).

thf(fact_380_add__strict__mono,axiom,(
    ! [C_21: int,D_3: int,A_42: int,B_35: int] :
      ( ( ord_less_int @ A_42 @ B_35 )
     => ( ( ord_less_int @ C_21 @ D_3 )
       => ( ord_less_int @ ( plus_plus_int @ A_42 @ C_21 ) @ ( plus_plus_int @ B_35 @ D_3 ) ) ) ) )).

thf(fact_381_add__strict__left__mono,axiom,(
    ! [C_20: real,A_41: real,B_34: real] :
      ( ( ord_less_real @ A_41 @ B_34 )
     => ( ord_less_real @ ( plus_plus_real @ C_20 @ A_41 ) @ ( plus_plus_real @ C_20 @ B_34 ) ) ) )).

thf(fact_382_add__strict__left__mono,axiom,(
    ! [C_20: nat,A_41: nat,B_34: nat] :
      ( ( ord_less_nat @ A_41 @ B_34 )
     => ( ord_less_nat @ ( plus_plus_nat @ C_20 @ A_41 ) @ ( plus_plus_nat @ C_20 @ B_34 ) ) ) )).

thf(fact_383_add__strict__left__mono,axiom,(
    ! [C_20: int,A_41: int,B_34: int] :
      ( ( ord_less_int @ A_41 @ B_34 )
     => ( ord_less_int @ ( plus_plus_int @ C_20 @ A_41 ) @ ( plus_plus_int @ C_20 @ B_34 ) ) ) )).

thf(fact_384_add__strict__right__mono,axiom,(
    ! [C_19: real,A_40: real,B_33: real] :
      ( ( ord_less_real @ A_40 @ B_33 )
     => ( ord_less_real @ ( plus_plus_real @ A_40 @ C_19 ) @ ( plus_plus_real @ B_33 @ C_19 ) ) ) )).

thf(fact_385_add__strict__right__mono,axiom,(
    ! [C_19: nat,A_40: nat,B_33: nat] :
      ( ( ord_less_nat @ A_40 @ B_33 )
     => ( ord_less_nat @ ( plus_plus_nat @ A_40 @ C_19 ) @ ( plus_plus_nat @ B_33 @ C_19 ) ) ) )).

thf(fact_386_add__strict__right__mono,axiom,(
    ! [C_19: int,A_40: int,B_33: int] :
      ( ( ord_less_int @ A_40 @ B_33 )
     => ( ord_less_int @ ( plus_plus_int @ A_40 @ C_19 ) @ ( plus_plus_int @ B_33 @ C_19 ) ) ) )).

thf(fact_387_add__less__cancel__left,axiom,(
    ! [C_18: real,A_39: real,B_32: real] :
      ( ( ord_less_real @ ( plus_plus_real @ C_18 @ A_39 ) @ ( plus_plus_real @ C_18 @ B_32 ) )
    <=> ( ord_less_real @ A_39 @ B_32 ) ) )).

thf(fact_388_add__less__cancel__left,axiom,(
    ! [C_18: nat,A_39: nat,B_32: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C_18 @ A_39 ) @ ( plus_plus_nat @ C_18 @ B_32 ) )
    <=> ( ord_less_nat @ A_39 @ B_32 ) ) )).

thf(fact_389_add__less__cancel__left,axiom,(
    ! [C_18: int,A_39: int,B_32: int] :
      ( ( ord_less_int @ ( plus_plus_int @ C_18 @ A_39 ) @ ( plus_plus_int @ C_18 @ B_32 ) )
    <=> ( ord_less_int @ A_39 @ B_32 ) ) )).

thf(fact_390_add__less__cancel__right,axiom,(
    ! [A_38: real,C_17: real,B_31: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A_38 @ C_17 ) @ ( plus_plus_real @ B_31 @ C_17 ) )
    <=> ( ord_less_real @ A_38 @ B_31 ) ) )).

thf(fact_391_add__less__cancel__right,axiom,(
    ! [A_38: nat,C_17: nat,B_31: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A_38 @ C_17 ) @ ( plus_plus_nat @ B_31 @ C_17 ) )
    <=> ( ord_less_nat @ A_38 @ B_31 ) ) )).

thf(fact_392_add__less__cancel__right,axiom,(
    ! [A_38: int,C_17: int,B_31: int] :
      ( ( ord_less_int @ ( plus_plus_int @ A_38 @ C_17 ) @ ( plus_plus_int @ B_31 @ C_17 ) )
    <=> ( ord_less_int @ A_38 @ B_31 ) ) )).

thf(fact_393_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,(
    ! [X_20: real] :
      ( ( power_power_real @ X_20 @ one_one_nat )
      = X_20 ) )).

thf(fact_394_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,(
    ! [X_20: nat] :
      ( ( power_power_nat @ X_20 @ one_one_nat )
      = X_20 ) )).

thf(fact_395_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,(
    ! [X_20: int] :
      ( ( power_power_int @ X_20 @ one_one_nat )
      = X_20 ) )).

thf(fact_396_nat__power__eq__0__iff,axiom,(
    ! [M: nat,N: nat] :
      ( ( ( power_power_nat @ M @ N )
        = zero_zero_nat )
    <=> ( ( N != zero_zero_nat )
        & ( M = zero_zero_nat ) ) ) )).

thf(fact_397_add__neg__neg,axiom,(
    ! [B_30: real,A_37: real] :
      ( ( ord_less_real @ A_37 @ zero_zero_real )
     => ( ( ord_less_real @ B_30 @ zero_zero_real )
       => ( ord_less_real @ ( plus_plus_real @ A_37 @ B_30 ) @ zero_zero_real ) ) ) )).

thf(fact_398_add__neg__neg,axiom,(
    ! [B_30: nat,A_37: nat] :
      ( ( ord_less_nat @ A_37 @ zero_zero_nat )
     => ( ( ord_less_nat @ B_30 @ zero_zero_nat )
       => ( ord_less_nat @ ( plus_plus_nat @ A_37 @ B_30 ) @ zero_zero_nat ) ) ) )).

thf(fact_399_add__neg__neg,axiom,(
    ! [B_30: int,A_37: int] :
      ( ( ord_less_int @ A_37 @ zero_zero_int )
     => ( ( ord_less_int @ B_30 @ zero_zero_int )
       => ( ord_less_int @ ( plus_plus_int @ A_37 @ B_30 ) @ zero_zero_int ) ) ) )).

thf(fact_400_add__pos__pos,axiom,(
    ! [B_29: real,A_36: real] :
      ( ( ord_less_real @ zero_zero_real @ A_36 )
     => ( ( ord_less_real @ zero_zero_real @ B_29 )
       => ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ A_36 @ B_29 ) ) ) ) )).

thf(fact_401_add__pos__pos,axiom,(
    ! [B_29: nat,A_36: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A_36 )
     => ( ( ord_less_nat @ zero_zero_nat @ B_29 )
       => ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ A_36 @ B_29 ) ) ) ) )).

thf(fact_402_add__pos__pos,axiom,(
    ! [B_29: int,A_36: int] :
      ( ( ord_less_int @ zero_zero_int @ A_36 )
     => ( ( ord_less_int @ zero_zero_int @ B_29 )
       => ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ A_36 @ B_29 ) ) ) ) )).

thf(fact_403_realpow__pos__nth__unique,axiom,(
    ! [A: real,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_real @ zero_zero_real @ A )
       => ? [X_14: real] :
            ( ( ord_less_real @ zero_zero_real @ X_14 )
            & ( ( power_power_real @ X_14 @ N )
              = A )
            & ! [Y_18: real] :
                ( ( ( ord_less_real @ zero_zero_real @ Y_18 )
                  & ( ( power_power_real @ Y_18 @ N )
                    = A ) )
               => ( Y_18 = X_14 ) ) ) ) ) )).

thf(fact_404_realpow__pos__nth,axiom,(
    ! [A: real,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_real @ zero_zero_real @ A )
       => ? [R: real] :
            ( ( ord_less_real @ zero_zero_real @ R )
            & ( ( power_power_real @ R @ N )
              = A ) ) ) ) )).

thf(fact_405_tpos,axiom,
    ( ord_less_eq_int @ one_one_int @ t )).

thf(fact_406_nat__number__of__add__1,axiom,(
    ! [V_1: int] :
      ( ( ( ord_less_int @ V_1 @ pls )
       => ( ( plus_plus_nat @ ( number_number_of_nat @ V_1 ) @ one_one_nat )
          = one_one_nat ) )
      & ( ~ ( ord_less_int @ V_1 @ pls )
       => ( ( plus_plus_nat @ ( number_number_of_nat @ V_1 ) @ one_one_nat )
          = ( number_number_of_nat @ ( succ @ V_1 ) ) ) ) ) )).

thf(fact_407_nat__1__add__number__of,axiom,(
    ! [V_1: int] :
      ( ( ( ord_less_int @ V_1 @ pls )
       => ( ( plus_plus_nat @ one_one_nat @ ( number_number_of_nat @ V_1 ) )
          = one_one_nat ) )
      & ( ~ ( ord_less_int @ V_1 @ pls )
       => ( ( plus_plus_nat @ one_one_nat @ ( number_number_of_nat @ V_1 ) )
          = ( number_number_of_nat @ ( succ @ V_1 ) ) ) ) ) )).

thf(fact_408_add__le__cancel__right,axiom,(
    ! [A_35: real,C_16: real,B_28: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A_35 @ C_16 ) @ ( plus_plus_real @ B_28 @ C_16 ) )
    <=> ( ord_less_eq_real @ A_35 @ B_28 ) ) )).

thf(fact_409_add__le__cancel__right,axiom,(
    ! [A_35: nat,C_16: nat,B_28: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A_35 @ C_16 ) @ ( plus_plus_nat @ B_28 @ C_16 ) )
    <=> ( ord_less_eq_nat @ A_35 @ B_28 ) ) )).

thf(fact_410_add__le__cancel__right,axiom,(
    ! [A_35: int,C_16: int,B_28: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ A_35 @ C_16 ) @ ( plus_plus_int @ B_28 @ C_16 ) )
    <=> ( ord_less_eq_int @ A_35 @ B_28 ) ) )).

thf(fact_411_add__le__cancel__left,axiom,(
    ! [C_15: real,A_34: real,B_27: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ C_15 @ A_34 ) @ ( plus_plus_real @ C_15 @ B_27 ) )
    <=> ( ord_less_eq_real @ A_34 @ B_27 ) ) )).

thf(fact_412_add__le__cancel__left,axiom,(
    ! [C_15: nat,A_34: nat,B_27: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C_15 @ A_34 ) @ ( plus_plus_nat @ C_15 @ B_27 ) )
    <=> ( ord_less_eq_nat @ A_34 @ B_27 ) ) )).

thf(fact_413_add__le__cancel__left,axiom,(
    ! [C_15: int,A_34: int,B_27: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ C_15 @ A_34 ) @ ( plus_plus_int @ C_15 @ B_27 ) )
    <=> ( ord_less_eq_int @ A_34 @ B_27 ) ) )).

thf(fact_414_add__right__mono,axiom,(
    ! [C_14: real,A_33: real,B_26: real] :
      ( ( ord_less_eq_real @ A_33 @ B_26 )
     => ( ord_less_eq_real @ ( plus_plus_real @ A_33 @ C_14 ) @ ( plus_plus_real @ B_26 @ C_14 ) ) ) )).

thf(fact_415_add__right__mono,axiom,(
    ! [C_14: nat,A_33: nat,B_26: nat] :
      ( ( ord_less_eq_nat @ A_33 @ B_26 )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ A_33 @ C_14 ) @ ( plus_plus_nat @ B_26 @ C_14 ) ) ) )).

thf(fact_416_add__right__mono,axiom,(
    ! [C_14: int,A_33: int,B_26: int] :
      ( ( ord_less_eq_int @ A_33 @ B_26 )
     => ( ord_less_eq_int @ ( plus_plus_int @ A_33 @ C_14 ) @ ( plus_plus_int @ B_26 @ C_14 ) ) ) )).

thf(fact_417_add__left__mono,axiom,(
    ! [C_13: real,A_32: real,B_25: real] :
      ( ( ord_less_eq_real @ A_32 @ B_25 )
     => ( ord_less_eq_real @ ( plus_plus_real @ C_13 @ A_32 ) @ ( plus_plus_real @ C_13 @ B_25 ) ) ) )).

thf(fact_418_add__left__mono,axiom,(
    ! [C_13: nat,A_32: nat,B_25: nat] :
      ( ( ord_less_eq_nat @ A_32 @ B_25 )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ C_13 @ A_32 ) @ ( plus_plus_nat @ C_13 @ B_25 ) ) ) )).

thf(fact_419_add__left__mono,axiom,(
    ! [C_13: int,A_32: int,B_25: int] :
      ( ( ord_less_eq_int @ A_32 @ B_25 )
     => ( ord_less_eq_int @ ( plus_plus_int @ C_13 @ A_32 ) @ ( plus_plus_int @ C_13 @ B_25 ) ) ) )).

thf(fact_420_add__mono,axiom,(
    ! [C_12: real,D_2: real,A_31: real,B_24: real] :
      ( ( ord_less_eq_real @ A_31 @ B_24 )
     => ( ( ord_less_eq_real @ C_12 @ D_2 )
       => ( ord_less_eq_real @ ( plus_plus_real @ A_31 @ C_12 ) @ ( plus_plus_real @ B_24 @ D_2 ) ) ) ) )).

thf(fact_421_add__mono,axiom,(
    ! [C_12: nat,D_2: nat,A_31: nat,B_24: nat] :
      ( ( ord_less_eq_nat @ A_31 @ B_24 )
     => ( ( ord_less_eq_nat @ C_12 @ D_2 )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ A_31 @ C_12 ) @ ( plus_plus_nat @ B_24 @ D_2 ) ) ) ) )).

thf(fact_422_add__mono,axiom,(
    ! [C_12: int,D_2: int,A_31: int,B_24: int] :
      ( ( ord_less_eq_int @ A_31 @ B_24 )
     => ( ( ord_less_eq_int @ C_12 @ D_2 )
       => ( ord_less_eq_int @ ( plus_plus_int @ A_31 @ C_12 ) @ ( plus_plus_int @ B_24 @ D_2 ) ) ) ) )).

thf(fact_423_add__le__imp__le__right,axiom,(
    ! [A_30: real,C_11: real,B_23: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A_30 @ C_11 ) @ ( plus_plus_real @ B_23 @ C_11 ) )
     => ( ord_less_eq_real @ A_30 @ B_23 ) ) )).

thf(fact_424_add__le__imp__le__right,axiom,(
    ! [A_30: nat,C_11: nat,B_23: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A_30 @ C_11 ) @ ( plus_plus_nat @ B_23 @ C_11 ) )
     => ( ord_less_eq_nat @ A_30 @ B_23 ) ) )).

thf(fact_425_add__le__imp__le__right,axiom,(
    ! [A_30: int,C_11: int,B_23: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ A_30 @ C_11 ) @ ( plus_plus_int @ B_23 @ C_11 ) )
     => ( ord_less_eq_int @ A_30 @ B_23 ) ) )).

thf(fact_426_add__le__imp__le__left,axiom,(
    ! [C_10: real,A_29: real,B_22: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ C_10 @ A_29 ) @ ( plus_plus_real @ C_10 @ B_22 ) )
     => ( ord_less_eq_real @ A_29 @ B_22 ) ) )).

thf(fact_427_add__le__imp__le__left,axiom,(
    ! [C_10: nat,A_29: nat,B_22: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C_10 @ A_29 ) @ ( plus_plus_nat @ C_10 @ B_22 ) )
     => ( ord_less_eq_nat @ A_29 @ B_22 ) ) )).

thf(fact_428_add__le__imp__le__left,axiom,(
    ! [C_10: int,A_29: int,B_22: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ C_10 @ A_29 ) @ ( plus_plus_int @ C_10 @ B_22 ) )
     => ( ord_less_eq_int @ A_29 @ B_22 ) ) )).

thf(fact_429_power__increasing,axiom,(
    ! [A_28: real,N_14: nat,N_13: nat] :
      ( ( ord_less_eq_nat @ N_14 @ N_13 )
     => ( ( ord_less_eq_real @ one_one_real @ A_28 )
       => ( ord_less_eq_real @ ( power_power_real @ A_28 @ N_14 ) @ ( power_power_real @ A_28 @ N_13 ) ) ) ) )).

thf(fact_430_power__increasing,axiom,(
    ! [A_28: nat,N_14: nat,N_13: nat] :
      ( ( ord_less_eq_nat @ N_14 @ N_13 )
     => ( ( ord_less_eq_nat @ one_one_nat @ A_28 )
       => ( ord_less_eq_nat @ ( power_power_nat @ A_28 @ N_14 ) @ ( power_power_nat @ A_28 @ N_13 ) ) ) ) )).

thf(fact_431_power__increasing,axiom,(
    ! [A_28: int,N_14: nat,N_13: nat] :
      ( ( ord_less_eq_nat @ N_14 @ N_13 )
     => ( ( ord_less_eq_int @ one_one_int @ A_28 )
       => ( ord_less_eq_int @ ( power_power_int @ A_28 @ N_14 ) @ ( power_power_int @ A_28 @ N_13 ) ) ) ) )).

thf(fact_432_less__eq__int__code_I16_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_eq_int @ ( bit1 @ K1 ) @ ( bit1 @ K2 ) )
    <=> ( ord_less_eq_int @ K1 @ K2 ) ) )).

thf(fact_433_rel__simps_I34_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_eq_int @ ( bit1 @ K ) @ ( bit1 @ L ) )
    <=> ( ord_less_eq_int @ K @ L ) ) )).

thf(fact_434_rel__simps_I19_J,axiom,
    ( ord_less_eq_int @ pls @ pls )).

thf(fact_435_less__eq__int__code_I13_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_eq_int @ ( bit0 @ K1 ) @ ( bit0 @ K2 ) )
    <=> ( ord_less_eq_int @ K1 @ K2 ) ) )).

thf(fact_436_rel__simps_I31_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_eq_int @ ( bit0 @ K ) @ ( bit0 @ L ) )
    <=> ( ord_less_eq_int @ K @ L ) ) )).

thf(fact_437_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ( ord_less_eq_int @ zero_zero_int @ zero_zero_int )).

thf(fact_438_zle__refl,axiom,(
    ! [W: int] :
      ( ord_less_eq_int @ W @ W ) )).

thf(fact_439_zle__linear,axiom,(
    ! [Z_2: int,W: int] :
      ( ( ord_less_eq_int @ Z_2 @ W )
      | ( ord_less_eq_int @ W @ Z_2 ) ) )).

thf(fact_440_zle__trans,axiom,(
    ! [K: int,I: int,J: int] :
      ( ( ord_less_eq_int @ I @ J )
     => ( ( ord_less_eq_int @ J @ K )
       => ( ord_less_eq_int @ I @ K ) ) ) )).

thf(fact_441_zle__antisym,axiom,(
    ! [Z_2: int,W: int] :
      ( ( ord_less_eq_int @ Z_2 @ W )
     => ( ( ord_less_eq_int @ W @ Z_2 )
       => ( Z_2 = W ) ) ) )).

thf(fact_442_le__number__of,axiom,(
    ! [X_19: int,Y_17: int] :
      ( ( ord_less_eq_real @ ( number267125858f_real @ X_19 ) @ ( number267125858f_real @ Y_17 ) )
    <=> ( ord_less_eq_int @ X_19 @ Y_17 ) ) )).

thf(fact_443_le__number__of,axiom,(
    ! [X_19: int,Y_17: int] :
      ( ( ord_less_eq_int @ ( number_number_of_int @ X_19 ) @ ( number_number_of_int @ Y_17 ) )
    <=> ( ord_less_eq_int @ X_19 @ Y_17 ) ) )).

thf(fact_444_of__nat__le__iff,axiom,(
    ! [M_4: nat,N_12: nat] :
      ( ( ord_less_eq_real @ ( semiri132038758t_real @ M_4 ) @ ( semiri132038758t_real @ N_12 ) )
    <=> ( ord_less_eq_nat @ M_4 @ N_12 ) ) )).

thf(fact_445_of__nat__le__iff,axiom,(
    ! [M_4: nat,N_12: nat] :
      ( ( ord_less_eq_nat @ ( semiri984289939at_nat @ M_4 ) @ ( semiri984289939at_nat @ N_12 ) )
    <=> ( ord_less_eq_nat @ M_4 @ N_12 ) ) )).

thf(fact_446_of__nat__le__iff,axiom,(
    ! [M_4: nat,N_12: nat] :
      ( ( ord_less_eq_int @ ( semiri1621563631at_int @ M_4 ) @ ( semiri1621563631at_int @ N_12 ) )
    <=> ( ord_less_eq_nat @ M_4 @ N_12 ) ) )).

thf(fact_447_zless__le,axiom,(
    ! [Z_2: int,W: int] :
      ( ( ord_less_int @ Z_2 @ W )
    <=> ( ( ord_less_eq_int @ Z_2 @ W )
        & ( Z_2 != W ) ) ) )).

thf(fact_448_zadd__left__mono,axiom,(
    ! [K: int,I: int,J: int] :
      ( ( ord_less_eq_int @ I @ J )
     => ( ord_less_eq_int @ ( plus_plus_int @ K @ I ) @ ( plus_plus_int @ K @ J ) ) ) )).

thf(fact_449_less__eq__number__of__int__code,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_eq_int @ ( number_number_of_int @ K ) @ ( number_number_of_int @ L ) )
    <=> ( ord_less_eq_int @ K @ L ) ) )).

thf(fact_450_le__special_I1_J,axiom,(
    ! [Y_16: int] :
      ( ( ord_less_eq_real @ zero_zero_real @ ( number267125858f_real @ Y_16 ) )
    <=> ( ord_less_eq_int @ pls @ Y_16 ) ) )).

thf(fact_451_le__special_I1_J,axiom,(
    ! [Y_16: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ Y_16 ) )
    <=> ( ord_less_eq_int @ pls @ Y_16 ) ) )).

thf(fact_452_le__special_I3_J,axiom,(
    ! [X_18: int] :
      ( ( ord_less_eq_real @ ( number267125858f_real @ X_18 ) @ zero_zero_real )
    <=> ( ord_less_eq_int @ X_18 @ pls ) ) )).

thf(fact_453_le__special_I3_J,axiom,(
    ! [X_18: int] :
      ( ( ord_less_eq_int @ ( number_number_of_int @ X_18 ) @ zero_zero_int )
    <=> ( ord_less_eq_int @ X_18 @ pls ) ) )).

thf(fact_454_power__decreasing,axiom,(
    ! [A_27: real,N_11: nat,N_10: nat] :
      ( ( ord_less_eq_nat @ N_11 @ N_10 )
     => ( ( ord_less_eq_real @ zero_zero_real @ A_27 )
       => ( ( ord_less_eq_real @ A_27 @ one_one_real )
         => ( ord_less_eq_real @ ( power_power_real @ A_27 @ N_10 ) @ ( power_power_real @ A_27 @ N_11 ) ) ) ) ) )).

thf(fact_455_power__decreasing,axiom,(
    ! [A_27: nat,N_11: nat,N_10: nat] :
      ( ( ord_less_eq_nat @ N_11 @ N_10 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ A_27 )
       => ( ( ord_less_eq_nat @ A_27 @ one_one_nat )
         => ( ord_less_eq_nat @ ( power_power_nat @ A_27 @ N_10 ) @ ( power_power_nat @ A_27 @ N_11 ) ) ) ) ) )).

thf(fact_456_power__decreasing,axiom,(
    ! [A_27: int,N_11: nat,N_10: nat] :
      ( ( ord_less_eq_nat @ N_11 @ N_10 )
     => ( ( ord_less_eq_int @ zero_zero_int @ A_27 )
       => ( ( ord_less_eq_int @ A_27 @ one_one_int )
         => ( ord_less_eq_int @ ( power_power_int @ A_27 @ N_10 ) @ ( power_power_int @ A_27 @ N_11 ) ) ) ) ) )).

thf(fact_457_power__increasing__iff,axiom,(
    ! [X_17: nat,Y_15: nat,B_21: real] :
      ( ( ord_less_real @ one_one_real @ B_21 )
     => ( ( ord_less_eq_real @ ( power_power_real @ B_21 @ X_17 ) @ ( power_power_real @ B_21 @ Y_15 ) )
      <=> ( ord_less_eq_nat @ X_17 @ Y_15 ) ) ) )).

thf(fact_458_power__increasing__iff,axiom,(
    ! [X_17: nat,Y_15: nat,B_21: nat] :
      ( ( ord_less_nat @ one_one_nat @ B_21 )
     => ( ( ord_less_eq_nat @ ( power_power_nat @ B_21 @ X_17 ) @ ( power_power_nat @ B_21 @ Y_15 ) )
      <=> ( ord_less_eq_nat @ X_17 @ Y_15 ) ) ) )).

thf(fact_459_power__increasing__iff,axiom,(
    ! [X_17: nat,Y_15: nat,B_21: int] :
      ( ( ord_less_int @ one_one_int @ B_21 )
     => ( ( ord_less_eq_int @ ( power_power_int @ B_21 @ X_17 ) @ ( power_power_int @ B_21 @ Y_15 ) )
      <=> ( ord_less_eq_nat @ X_17 @ Y_15 ) ) ) )).

thf(fact_460_power__le__imp__le__exp,axiom,(
    ! [M_3: nat,N_9: nat,A_26: real] :
      ( ( ord_less_real @ one_one_real @ A_26 )
     => ( ( ord_less_eq_real @ ( power_power_real @ A_26 @ M_3 ) @ ( power_power_real @ A_26 @ N_9 ) )
       => ( ord_less_eq_nat @ M_3 @ N_9 ) ) ) )).

thf(fact_461_power__le__imp__le__exp,axiom,(
    ! [M_3: nat,N_9: nat,A_26: nat] :
      ( ( ord_less_nat @ one_one_nat @ A_26 )
     => ( ( ord_less_eq_nat @ ( power_power_nat @ A_26 @ M_3 ) @ ( power_power_nat @ A_26 @ N_9 ) )
       => ( ord_less_eq_nat @ M_3 @ N_9 ) ) ) )).

thf(fact_462_power__le__imp__le__exp,axiom,(
    ! [M_3: nat,N_9: nat,A_26: int] :
      ( ( ord_less_int @ one_one_int @ A_26 )
     => ( ( ord_less_eq_int @ ( power_power_int @ A_26 @ M_3 ) @ ( power_power_int @ A_26 @ N_9 ) )
       => ( ord_less_eq_nat @ M_3 @ N_9 ) ) ) )).

thf(fact_463_le__special_I2_J,axiom,(
    ! [Y_14: int] :
      ( ( ord_less_eq_real @ one_one_real @ ( number267125858f_real @ Y_14 ) )
    <=> ( ord_less_eq_int @ ( bit1 @ pls ) @ Y_14 ) ) )).

thf(fact_464_le__special_I2_J,axiom,(
    ! [Y_14: int] :
      ( ( ord_less_eq_int @ one_one_int @ ( number_number_of_int @ Y_14 ) )
    <=> ( ord_less_eq_int @ ( bit1 @ pls ) @ Y_14 ) ) )).

thf(fact_465_le__special_I4_J,axiom,(
    ! [X_16: int] :
      ( ( ord_less_eq_real @ ( number267125858f_real @ X_16 ) @ one_one_real )
    <=> ( ord_less_eq_int @ X_16 @ ( bit1 @ pls ) ) ) )).

thf(fact_466_le__special_I4_J,axiom,(
    ! [X_16: int] :
      ( ( ord_less_eq_int @ ( number_number_of_int @ X_16 ) @ one_one_int )
    <=> ( ord_less_eq_int @ X_16 @ ( bit1 @ pls ) ) ) )).

thf(fact_467_zero__le__double__add__iff__zero__le__single__add,axiom,(
    ! [A_25: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ ( plus_plus_real @ A_25 @ A_25 ) )
    <=> ( ord_less_eq_real @ zero_zero_real @ A_25 ) ) )).

thf(fact_468_zero__le__double__add__iff__zero__le__single__add,axiom,(
    ! [A_25: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ ( plus_plus_int @ A_25 @ A_25 ) )
    <=> ( ord_less_eq_int @ zero_zero_int @ A_25 ) ) )).

thf(fact_469_double__add__le__zero__iff__single__add__le__zero,axiom,(
    ! [A_24: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A_24 @ A_24 ) @ zero_zero_real )
    <=> ( ord_less_eq_real @ A_24 @ zero_zero_real ) ) )).

thf(fact_470_double__add__le__zero__iff__single__add__le__zero,axiom,(
    ! [A_24: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ A_24 @ A_24 ) @ zero_zero_int )
    <=> ( ord_less_eq_int @ A_24 @ zero_zero_int ) ) )).

thf(fact_471_add__nonneg__nonneg,axiom,(
    ! [B_20: real,A_23: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A_23 )
     => ( ( ord_less_eq_real @ zero_zero_real @ B_20 )
       => ( ord_less_eq_real @ zero_zero_real @ ( plus_plus_real @ A_23 @ B_20 ) ) ) ) )).

thf(fact_472_add__nonneg__nonneg,axiom,(
    ! [B_20: nat,A_23: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ A_23 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ B_20 )
       => ( ord_less_eq_nat @ zero_zero_nat @ ( plus_plus_nat @ A_23 @ B_20 ) ) ) ) )).

thf(fact_473_add__nonneg__nonneg,axiom,(
    ! [B_20: int,A_23: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ A_23 )
     => ( ( ord_less_eq_int @ zero_zero_int @ B_20 )
       => ( ord_less_eq_int @ zero_zero_int @ ( plus_plus_int @ A_23 @ B_20 ) ) ) ) )).

thf(fact_474_add__nonneg__eq__0__iff,axiom,(
    ! [Y_13: real,X_15: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ X_15 )
     => ( ( ord_less_eq_real @ zero_zero_real @ Y_13 )
       => ( ( ( plus_plus_real @ X_15 @ Y_13 )
            = zero_zero_real )
        <=> ( ( X_15 = zero_zero_real )
            & ( Y_13 = zero_zero_real ) ) ) ) ) )).

thf(fact_475_add__nonneg__eq__0__iff,axiom,(
    ! [Y_13: nat,X_15: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ X_15 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ Y_13 )
       => ( ( ( plus_plus_nat @ X_15 @ Y_13 )
            = zero_zero_nat )
        <=> ( ( X_15 = zero_zero_nat )
            & ( Y_13 = zero_zero_nat ) ) ) ) ) )).

thf(fact_476_add__nonneg__eq__0__iff,axiom,(
    ! [Y_13: int,X_15: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ X_15 )
     => ( ( ord_less_eq_int @ zero_zero_int @ Y_13 )
       => ( ( ( plus_plus_int @ X_15 @ Y_13 )
            = zero_zero_int )
        <=> ( ( X_15 = zero_zero_int )
            & ( Y_13 = zero_zero_int ) ) ) ) ) )).

thf(fact_477_add__increasing,axiom,(
    ! [B_19: real,C_9: real,A_22: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A_22 )
     => ( ( ord_less_eq_real @ B_19 @ C_9 )
       => ( ord_less_eq_real @ B_19 @ ( plus_plus_real @ A_22 @ C_9 ) ) ) ) )).

thf(fact_478_add__increasing,axiom,(
    ! [B_19: nat,C_9: nat,A_22: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ A_22 )
     => ( ( ord_less_eq_nat @ B_19 @ C_9 )
       => ( ord_less_eq_nat @ B_19 @ ( plus_plus_nat @ A_22 @ C_9 ) ) ) ) )).

thf(fact_479_add__increasing,axiom,(
    ! [B_19: int,C_9: int,A_22: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ A_22 )
     => ( ( ord_less_eq_int @ B_19 @ C_9 )
       => ( ord_less_eq_int @ B_19 @ ( plus_plus_int @ A_22 @ C_9 ) ) ) ) )).

thf(fact_480_add__increasing2,axiom,(
    ! [B_18: real,A_21: real,C_8: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ C_8 )
     => ( ( ord_less_eq_real @ B_18 @ A_21 )
       => ( ord_less_eq_real @ B_18 @ ( plus_plus_real @ A_21 @ C_8 ) ) ) ) )).

thf(fact_481_add__increasing2,axiom,(
    ! [B_18: nat,A_21: nat,C_8: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ C_8 )
     => ( ( ord_less_eq_nat @ B_18 @ A_21 )
       => ( ord_less_eq_nat @ B_18 @ ( plus_plus_nat @ A_21 @ C_8 ) ) ) ) )).

thf(fact_482_add__increasing2,axiom,(
    ! [B_18: int,A_21: int,C_8: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ C_8 )
     => ( ( ord_less_eq_int @ B_18 @ A_21 )
       => ( ord_less_eq_int @ B_18 @ ( plus_plus_int @ A_21 @ C_8 ) ) ) ) )).

thf(fact_483_add__nonpos__nonpos,axiom,(
    ! [B_17: real,A_20: real] :
      ( ( ord_less_eq_real @ A_20 @ zero_zero_real )
     => ( ( ord_less_eq_real @ B_17 @ zero_zero_real )
       => ( ord_less_eq_real @ ( plus_plus_real @ A_20 @ B_17 ) @ zero_zero_real ) ) ) )).

thf(fact_484_add__nonpos__nonpos,axiom,(
    ! [B_17: nat,A_20: nat] :
      ( ( ord_less_eq_nat @ A_20 @ zero_zero_nat )
     => ( ( ord_less_eq_nat @ B_17 @ zero_zero_nat )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ A_20 @ B_17 ) @ zero_zero_nat ) ) ) )).

thf(fact_485_add__nonpos__nonpos,axiom,(
    ! [B_17: int,A_20: int] :
      ( ( ord_less_eq_int @ A_20 @ zero_zero_int )
     => ( ( ord_less_eq_int @ B_17 @ zero_zero_int )
       => ( ord_less_eq_int @ ( plus_plus_int @ A_20 @ B_17 ) @ zero_zero_int ) ) ) )).

thf(fact_486_add__less__le__mono,axiom,(
    ! [C_7: real,D_1: real,A_19: real,B_16: real] :
      ( ( ord_less_real @ A_19 @ B_16 )
     => ( ( ord_less_eq_real @ C_7 @ D_1 )
       => ( ord_less_real @ ( plus_plus_real @ A_19 @ C_7 ) @ ( plus_plus_real @ B_16 @ D_1 ) ) ) ) )).

thf(fact_487_add__less__le__mono,axiom,(
    ! [C_7: nat,D_1: nat,A_19: nat,B_16: nat] :
      ( ( ord_less_nat @ A_19 @ B_16 )
     => ( ( ord_less_eq_nat @ C_7 @ D_1 )
       => ( ord_less_nat @ ( plus_plus_nat @ A_19 @ C_7 ) @ ( plus_plus_nat @ B_16 @ D_1 ) ) ) ) )).

thf(fact_488_add__less__le__mono,axiom,(
    ! [C_7: int,D_1: int,A_19: int,B_16: int] :
      ( ( ord_less_int @ A_19 @ B_16 )
     => ( ( ord_less_eq_int @ C_7 @ D_1 )
       => ( ord_less_int @ ( plus_plus_int @ A_19 @ C_7 ) @ ( plus_plus_int @ B_16 @ D_1 ) ) ) ) )).

thf(fact_489_add__le__less__mono,axiom,(
    ! [C_6: real,D: real,A_18: real,B_15: real] :
      ( ( ord_less_eq_real @ A_18 @ B_15 )
     => ( ( ord_less_real @ C_6 @ D )
       => ( ord_less_real @ ( plus_plus_real @ A_18 @ C_6 ) @ ( plus_plus_real @ B_15 @ D ) ) ) ) )).

thf(fact_490_add__le__less__mono,axiom,(
    ! [C_6: nat,D: nat,A_18: nat,B_15: nat] :
      ( ( ord_less_eq_nat @ A_18 @ B_15 )
     => ( ( ord_less_nat @ C_6 @ D )
       => ( ord_less_nat @ ( plus_plus_nat @ A_18 @ C_6 ) @ ( plus_plus_nat @ B_15 @ D ) ) ) ) )).

thf(fact_491_add__le__less__mono,axiom,(
    ! [C_6: int,D: int,A_18: int,B_15: int] :
      ( ( ord_less_eq_int @ A_18 @ B_15 )
     => ( ( ord_less_int @ C_6 @ D )
       => ( ord_less_int @ ( plus_plus_int @ A_18 @ C_6 ) @ ( plus_plus_int @ B_15 @ D ) ) ) ) )).

thf(fact_492_not__one__le__zero,axiom,(
    ~ ( ord_less_eq_real @ one_one_real @ zero_zero_real ) )).

thf(fact_493_not__one__le__zero,axiom,(
    ~ ( ord_less_eq_nat @ one_one_nat @ zero_zero_nat ) )).

thf(fact_494_not__one__le__zero,axiom,(
    ~ ( ord_less_eq_int @ one_one_int @ zero_zero_int ) )).

thf(fact_495_zero__le__one,axiom,
    ( ord_less_eq_real @ zero_zero_real @ one_one_real )).

thf(fact_496_zero__le__one,axiom,
    ( ord_less_eq_nat @ zero_zero_nat @ one_one_nat )).

thf(fact_497_zero__le__one,axiom,
    ( ord_less_eq_int @ zero_zero_int @ one_one_int )).

thf(fact_498_le__number__of__eq__not__less,axiom,(
    ! [V_7: int,W_2: int] :
      ( ( ord_less_eq_real @ ( number267125858f_real @ V_7 ) @ ( number267125858f_real @ W_2 ) )
    <=> ~ ( ord_less_real @ ( number267125858f_real @ W_2 ) @ ( number267125858f_real @ V_7 ) ) ) )).

thf(fact_499_le__number__of__eq__not__less,axiom,(
    ! [V_7: int,W_2: int] :
      ( ( ord_less_eq_nat @ ( number_number_of_nat @ V_7 ) @ ( number_number_of_nat @ W_2 ) )
    <=> ~ ( ord_less_nat @ ( number_number_of_nat @ W_2 ) @ ( number_number_of_nat @ V_7 ) ) ) )).

thf(fact_500_le__number__of__eq__not__less,axiom,(
    ! [V_7: int,W_2: int] :
      ( ( ord_less_eq_int @ ( number_number_of_int @ V_7 ) @ ( number_number_of_int @ W_2 ) )
    <=> ~ ( ord_less_int @ ( number_number_of_int @ W_2 ) @ ( number_number_of_int @ V_7 ) ) ) )).

thf(fact_501_zero__le__power,axiom,(
    ! [N_8: nat,A_17: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A_17 )
     => ( ord_less_eq_real @ zero_zero_real @ ( power_power_real @ A_17 @ N_8 ) ) ) )).

thf(fact_502_zero__le__power,axiom,(
    ! [N_8: nat,A_17: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ A_17 )
     => ( ord_less_eq_nat @ zero_zero_nat @ ( power_power_nat @ A_17 @ N_8 ) ) ) )).

thf(fact_503_zero__le__power,axiom,(
    ! [N_8: nat,A_17: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ A_17 )
     => ( ord_less_eq_int @ zero_zero_int @ ( power_power_int @ A_17 @ N_8 ) ) ) )).

thf(fact_504_power__mono,axiom,(
    ! [N_7: nat,A_16: real,B_14: real] :
      ( ( ord_less_eq_real @ A_16 @ B_14 )
     => ( ( ord_less_eq_real @ zero_zero_real @ A_16 )
       => ( ord_less_eq_real @ ( power_power_real @ A_16 @ N_7 ) @ ( power_power_real @ B_14 @ N_7 ) ) ) ) )).

thf(fact_505_power__mono,axiom,(
    ! [N_7: nat,A_16: nat,B_14: nat] :
      ( ( ord_less_eq_nat @ A_16 @ B_14 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ A_16 )
       => ( ord_less_eq_nat @ ( power_power_nat @ A_16 @ N_7 ) @ ( power_power_nat @ B_14 @ N_7 ) ) ) ) )).

thf(fact_506_power__mono,axiom,(
    ! [N_7: nat,A_16: int,B_14: int] :
      ( ( ord_less_eq_int @ A_16 @ B_14 )
     => ( ( ord_less_eq_int @ zero_zero_int @ A_16 )
       => ( ord_less_eq_int @ ( power_power_int @ A_16 @ N_7 ) @ ( power_power_int @ B_14 @ N_7 ) ) ) ) )).

thf(fact_507_one__le__power,axiom,(
    ! [N_6: nat,A_15: real] :
      ( ( ord_less_eq_real @ one_one_real @ A_15 )
     => ( ord_less_eq_real @ one_one_real @ ( power_power_real @ A_15 @ N_6 ) ) ) )).

thf(fact_508_one__le__power,axiom,(
    ! [N_6: nat,A_15: nat] :
      ( ( ord_less_eq_nat @ one_one_nat @ A_15 )
     => ( ord_less_eq_nat @ one_one_nat @ ( power_power_nat @ A_15 @ N_6 ) ) ) )).

thf(fact_509_one__le__power,axiom,(
    ! [N_6: nat,A_15: int] :
      ( ( ord_less_eq_int @ one_one_int @ A_15 )
     => ( ord_less_eq_int @ one_one_int @ ( power_power_int @ A_15 @ N_6 ) ) ) )).

thf(fact_510_zero__le__imp__of__nat,axiom,(
    ! [M_2: nat] :
      ( ord_less_eq_real @ zero_zero_real @ ( semiri132038758t_real @ M_2 ) ) )).

thf(fact_511_zero__le__imp__of__nat,axiom,(
    ! [M_2: nat] :
      ( ord_less_eq_nat @ zero_zero_nat @ ( semiri984289939at_nat @ M_2 ) ) )).

thf(fact_512_zero__le__imp__of__nat,axiom,(
    ! [M_2: nat] :
      ( ord_less_eq_int @ zero_zero_int @ ( semiri1621563631at_int @ M_2 ) ) )).

thf(fact_513_of__nat__0__le__iff,axiom,(
    ! [N_5: nat] :
      ( ord_less_eq_real @ zero_zero_real @ ( semiri132038758t_real @ N_5 ) ) )).

thf(fact_514_of__nat__0__le__iff,axiom,(
    ! [N_5: nat] :
      ( ord_less_eq_nat @ zero_zero_nat @ ( semiri984289939at_nat @ N_5 ) ) )).

thf(fact_515_of__nat__0__le__iff,axiom,(
    ! [N_5: nat] :
      ( ord_less_eq_int @ zero_zero_int @ ( semiri1621563631at_int @ N_5 ) ) )).

thf(fact_516_rel__simps_I22_J,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ pls @ ( bit1 @ K ) )
    <=> ( ord_less_eq_int @ pls @ K ) ) )).

thf(fact_517_rel__simps_I32_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_eq_int @ ( bit0 @ K ) @ ( bit1 @ L ) )
    <=> ( ord_less_eq_int @ K @ L ) ) )).

thf(fact_518_less__eq__int__code_I14_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_eq_int @ ( bit0 @ K1 ) @ ( bit1 @ K2 ) )
    <=> ( ord_less_eq_int @ K1 @ K2 ) ) )).

thf(fact_519_rel__simps_I21_J,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ pls @ ( bit0 @ K ) )
    <=> ( ord_less_eq_int @ pls @ K ) ) )).

thf(fact_520_rel__simps_I27_J,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ ( bit0 @ K ) @ pls )
    <=> ( ord_less_eq_int @ K @ pls ) ) )).

thf(fact_521_Nat__Transfer_Otransfer__nat__int__function__closures_I6_J,axiom,
    ( ord_less_eq_int @ zero_zero_int @ one_one_int )).

thf(fact_522_Nat__Transfer_Otransfer__nat__int__function__closures_I1_J,axiom,(
    ! [Y: int,X: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ X )
     => ( ( ord_less_eq_int @ zero_zero_int @ Y )
       => ( ord_less_eq_int @ zero_zero_int @ ( plus_plus_int @ X @ Y ) ) ) ) )).

thf(fact_523_zadd__zless__mono,axiom,(
    ! [Z_3: int,Z_2: int,W_1: int,W: int] :
      ( ( ord_less_int @ W_1 @ W )
     => ( ( ord_less_eq_int @ Z_3 @ Z_2 )
       => ( ord_less_int @ ( plus_plus_int @ W_1 @ Z_3 ) @ ( plus_plus_int @ W @ Z_2 ) ) ) ) )).

thf(fact_524_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,(
    ! [Z_2: nat] :
      ( ord_less_eq_int @ zero_zero_int @ ( semiri1621563631at_int @ Z_2 ) ) )).

thf(fact_525_transfer__int__nat__quantifiers_I2_J,axiom,(
    ! [P: int > $o] :
      ( ? [X_14: int] :
          ( ( ord_less_eq_int @ zero_zero_int @ X_14 )
          & ( P @ X_14 ) )
    <=> ? [X_14: nat] :
          ( P @ ( semiri1621563631at_int @ X_14 ) ) ) )).

thf(fact_526_transfer__int__nat__quantifiers_I1_J,axiom,(
    ! [P: int > $o] :
      ( ! [X_14: int] :
          ( ( ord_less_eq_int @ zero_zero_int @ X_14 )
         => ( P @ X_14 ) )
    <=> ! [X_14: nat] :
          ( P @ ( semiri1621563631at_int @ X_14 ) ) ) )).

thf(fact_527_zero__zle__int,axiom,(
    ! [N: nat] :
      ( ord_less_eq_int @ zero_zero_int @ ( semiri1621563631at_int @ N ) ) )).

thf(fact_528_Nat__Transfer_Otransfer__nat__int__function__closures_I4_J,axiom,(
    ! [N: nat,X: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ X )
     => ( ord_less_eq_int @ zero_zero_int @ ( power_power_int @ X @ N ) ) ) )).

thf(fact_529_zle__iff__zadd,axiom,(
    ! [W: int,Z_2: int] :
      ( ( ord_less_eq_int @ W @ Z_2 )
    <=> ? [N_1: nat] :
          ( Z_2
          = ( plus_plus_int @ W @ ( semiri1621563631at_int @ N_1 ) ) ) ) )).

thf(fact_530_semiring__1__add__number__of,axiom,(
    ! [V_6: int] :
      ( ( ord_less_eq_int @ pls @ V_6 )
     => ( ( plus_plus_real @ one_one_real @ ( number267125858f_real @ V_6 ) )
        = ( number267125858f_real @ ( succ @ V_6 ) ) ) ) )).

thf(fact_531_semiring__1__add__number__of,axiom,(
    ! [V_6: int] :
      ( ( ord_less_eq_int @ pls @ V_6 )
     => ( ( plus_plus_nat @ one_one_nat @ ( number_number_of_nat @ V_6 ) )
        = ( number_number_of_nat @ ( succ @ V_6 ) ) ) ) )).

thf(fact_532_semiring__1__add__number__of,axiom,(
    ! [V_6: int] :
      ( ( ord_less_eq_int @ pls @ V_6 )
     => ( ( plus_plus_int @ one_one_int @ ( number_number_of_int @ V_6 ) )
        = ( number_number_of_int @ ( succ @ V_6 ) ) ) ) )).

thf(fact_533_semiring__number__of__add__1,axiom,(
    ! [V_5: int] :
      ( ( ord_less_eq_int @ pls @ V_5 )
     => ( ( plus_plus_real @ ( number267125858f_real @ V_5 ) @ one_one_real )
        = ( number267125858f_real @ ( succ @ V_5 ) ) ) ) )).

thf(fact_534_semiring__number__of__add__1,axiom,(
    ! [V_5: int] :
      ( ( ord_less_eq_int @ pls @ V_5 )
     => ( ( plus_plus_nat @ ( number_number_of_nat @ V_5 ) @ one_one_nat )
        = ( number_number_of_nat @ ( succ @ V_5 ) ) ) ) )).

thf(fact_535_semiring__number__of__add__1,axiom,(
    ! [V_5: int] :
      ( ( ord_less_eq_int @ pls @ V_5 )
     => ( ( plus_plus_int @ ( number_number_of_int @ V_5 ) @ one_one_int )
        = ( number_number_of_int @ ( succ @ V_5 ) ) ) ) )).

thf(fact_536_add__pos__nonneg,axiom,(
    ! [B_13: real,A_14: real] :
      ( ( ord_less_real @ zero_zero_real @ A_14 )
     => ( ( ord_less_eq_real @ zero_zero_real @ B_13 )
       => ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ A_14 @ B_13 ) ) ) ) )).

thf(fact_537_add__pos__nonneg,axiom,(
    ! [B_13: nat,A_14: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A_14 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ B_13 )
       => ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ A_14 @ B_13 ) ) ) ) )).

thf(fact_538_add__pos__nonneg,axiom,(
    ! [B_13: int,A_14: int] :
      ( ( ord_less_int @ zero_zero_int @ A_14 )
     => ( ( ord_less_eq_int @ zero_zero_int @ B_13 )
       => ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ A_14 @ B_13 ) ) ) ) )).

thf(fact_539_add__nonneg__pos,axiom,(
    ! [B_12: real,A_13: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A_13 )
     => ( ( ord_less_real @ zero_zero_real @ B_12 )
       => ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ A_13 @ B_12 ) ) ) ) )).

thf(fact_540_add__nonneg__pos,axiom,(
    ! [B_12: nat,A_13: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ A_13 )
     => ( ( ord_less_nat @ zero_zero_nat @ B_12 )
       => ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ A_13 @ B_12 ) ) ) ) )).

thf(fact_541_add__nonneg__pos,axiom,(
    ! [B_12: int,A_13: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ A_13 )
     => ( ( ord_less_int @ zero_zero_int @ B_12 )
       => ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ A_13 @ B_12 ) ) ) ) )).

thf(fact_542_add__strict__increasing,axiom,(
    ! [B_11: real,C_5: real,A_12: real] :
      ( ( ord_less_real @ zero_zero_real @ A_12 )
     => ( ( ord_less_eq_real @ B_11 @ C_5 )
       => ( ord_less_real @ B_11 @ ( plus_plus_real @ A_12 @ C_5 ) ) ) ) )).

thf(fact_543_add__strict__increasing,axiom,(
    ! [B_11: nat,C_5: nat,A_12: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A_12 )
     => ( ( ord_less_eq_nat @ B_11 @ C_5 )
       => ( ord_less_nat @ B_11 @ ( plus_plus_nat @ A_12 @ C_5 ) ) ) ) )).

thf(fact_544_add__strict__increasing,axiom,(
    ! [B_11: int,C_5: int,A_12: int] :
      ( ( ord_less_int @ zero_zero_int @ A_12 )
     => ( ( ord_less_eq_int @ B_11 @ C_5 )
       => ( ord_less_int @ B_11 @ ( plus_plus_int @ A_12 @ C_5 ) ) ) ) )).

thf(fact_545_add__strict__increasing2,axiom,(
    ! [B_10: real,C_4: real,A_11: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A_11 )
     => ( ( ord_less_real @ B_10 @ C_4 )
       => ( ord_less_real @ B_10 @ ( plus_plus_real @ A_11 @ C_4 ) ) ) ) )).

thf(fact_546_add__strict__increasing2,axiom,(
    ! [B_10: nat,C_4: nat,A_11: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ A_11 )
     => ( ( ord_less_nat @ B_10 @ C_4 )
       => ( ord_less_nat @ B_10 @ ( plus_plus_nat @ A_11 @ C_4 ) ) ) ) )).

thf(fact_547_add__strict__increasing2,axiom,(
    ! [B_10: int,C_4: int,A_11: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ A_11 )
     => ( ( ord_less_int @ B_10 @ C_4 )
       => ( ord_less_int @ B_10 @ ( plus_plus_int @ A_11 @ C_4 ) ) ) ) )).

thf(fact_548_add__neg__nonpos,axiom,(
    ! [B_9: real,A_10: real] :
      ( ( ord_less_real @ A_10 @ zero_zero_real )
     => ( ( ord_less_eq_real @ B_9 @ zero_zero_real )
       => ( ord_less_real @ ( plus_plus_real @ A_10 @ B_9 ) @ zero_zero_real ) ) ) )).

thf(fact_549_add__neg__nonpos,axiom,(
    ! [B_9: nat,A_10: nat] :
      ( ( ord_less_nat @ A_10 @ zero_zero_nat )
     => ( ( ord_less_eq_nat @ B_9 @ zero_zero_nat )
       => ( ord_less_nat @ ( plus_plus_nat @ A_10 @ B_9 ) @ zero_zero_nat ) ) ) )).

thf(fact_550_add__neg__nonpos,axiom,(
    ! [B_9: int,A_10: int] :
      ( ( ord_less_int @ A_10 @ zero_zero_int )
     => ( ( ord_less_eq_int @ B_9 @ zero_zero_int )
       => ( ord_less_int @ ( plus_plus_int @ A_10 @ B_9 ) @ zero_zero_int ) ) ) )).

thf(fact_551_add__nonpos__neg,axiom,(
    ! [B_8: real,A_9: real] :
      ( ( ord_less_eq_real @ A_9 @ zero_zero_real )
     => ( ( ord_less_real @ B_8 @ zero_zero_real )
       => ( ord_less_real @ ( plus_plus_real @ A_9 @ B_8 ) @ zero_zero_real ) ) ) )).

thf(fact_552_add__nonpos__neg,axiom,(
    ! [B_8: nat,A_9: nat] :
      ( ( ord_less_eq_nat @ A_9 @ zero_zero_nat )
     => ( ( ord_less_nat @ B_8 @ zero_zero_nat )
       => ( ord_less_nat @ ( plus_plus_nat @ A_9 @ B_8 ) @ zero_zero_nat ) ) ) )).

thf(fact_553_add__nonpos__neg,axiom,(
    ! [B_8: int,A_9: int] :
      ( ( ord_less_eq_int @ A_9 @ zero_zero_int )
     => ( ( ord_less_int @ B_8 @ zero_zero_int )
       => ( ord_less_int @ ( plus_plus_int @ A_9 @ B_8 ) @ zero_zero_int ) ) ) )).

thf(fact_554_power__less__imp__less__base,axiom,(
    ! [A_8: real,N_4: nat,B_7: real] :
      ( ( ord_less_real @ ( power_power_real @ A_8 @ N_4 ) @ ( power_power_real @ B_7 @ N_4 ) )
     => ( ( ord_less_eq_real @ zero_zero_real @ B_7 )
       => ( ord_less_real @ A_8 @ B_7 ) ) ) )).

thf(fact_555_power__less__imp__less__base,axiom,(
    ! [A_8: nat,N_4: nat,B_7: nat] :
      ( ( ord_less_nat @ ( power_power_nat @ A_8 @ N_4 ) @ ( power_power_nat @ B_7 @ N_4 ) )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ B_7 )
       => ( ord_less_nat @ A_8 @ B_7 ) ) ) )).

thf(fact_556_power__less__imp__less__base,axiom,(
    ! [A_8: int,N_4: nat,B_7: int] :
      ( ( ord_less_int @ ( power_power_int @ A_8 @ N_4 ) @ ( power_power_int @ B_7 @ N_4 ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ B_7 )
       => ( ord_less_int @ A_8 @ B_7 ) ) ) )).

thf(fact_557_eq__0__number__of,axiom,(
    ! [V_1: int] :
      ( ( zero_zero_nat
        = ( number_number_of_nat @ V_1 ) )
    <=> ( ord_less_eq_int @ V_1 @ pls ) ) )).

thf(fact_558_eq__number__of__0,axiom,(
    ! [V_1: int] :
      ( ( ( number_number_of_nat @ V_1 )
        = zero_zero_nat )
    <=> ( ord_less_eq_int @ V_1 @ pls ) ) )).

thf(fact_559_rel__simps_I5_J,axiom,(
    ! [K: int] :
      ( ( ord_less_int @ pls @ ( bit1 @ K ) )
    <=> ( ord_less_eq_int @ pls @ K ) ) )).

thf(fact_560_rel__simps_I29_J,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ ( bit1 @ K ) @ pls )
    <=> ( ord_less_int @ K @ pls ) ) )).

thf(fact_561_rel__simps_I15_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_int @ ( bit0 @ K ) @ ( bit1 @ L ) )
    <=> ( ord_less_eq_int @ K @ L ) ) )).

thf(fact_562_less__int__code_I14_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_int @ ( bit0 @ K1 ) @ ( bit1 @ K2 ) )
    <=> ( ord_less_eq_int @ K1 @ K2 ) ) )).

thf(fact_563_rel__simps_I33_J,axiom,(
    ! [K: int,L: int] :
      ( ( ord_less_eq_int @ ( bit1 @ K ) @ ( bit0 @ L ) )
    <=> ( ord_less_int @ K @ L ) ) )).

thf(fact_564_less__eq__int__code_I15_J,axiom,(
    ! [K1: int,K2: int] :
      ( ( ord_less_eq_int @ ( bit1 @ K1 ) @ ( bit0 @ K2 ) )
    <=> ( ord_less_int @ K1 @ K2 ) ) )).

thf(fact_565_int__one__le__iff__zero__less,axiom,(
    ! [Z_2: int] :
      ( ( ord_less_eq_int @ one_one_int @ Z_2 )
    <=> ( ord_less_int @ zero_zero_int @ Z_2 ) ) )).

thf(fact_566_int__le__0__conv,axiom,(
    ! [N: nat] :
      ( ( ord_less_eq_int @ ( semiri1621563631at_int @ N ) @ zero_zero_int )
    <=> ( N = zero_zero_nat ) ) )).

thf(fact_567_succ__Pls,axiom,
    ( ( succ @ pls )
    = ( bit1 @ pls ) )).

thf(fact_568_succ__Bit0,axiom,(
    ! [K: int] :
      ( ( succ @ ( bit0 @ K ) )
      = ( bit1 @ K ) ) )).

thf(fact_569_succ__Bit1,axiom,(
    ! [K: int] :
      ( ( succ @ ( bit1 @ K ) )
      = ( bit0 @ ( succ @ K ) ) ) )).

thf(fact_570_zle__add1__eq__le,axiom,(
    ! [W: int,Z_2: int] :
      ( ( ord_less_int @ W @ ( plus_plus_int @ Z_2 @ one_one_int ) )
    <=> ( ord_less_eq_int @ W @ Z_2 ) ) )).

thf(fact_571_add1__zle__eq,axiom,(
    ! [W: int,Z_2: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ W @ one_one_int ) @ Z_2 )
    <=> ( ord_less_int @ W @ Z_2 ) ) )).

thf(fact_572_zless__imp__add1__zle,axiom,(
    ! [W: int,Z_2: int] :
      ( ( ord_less_int @ W @ Z_2 )
     => ( ord_less_eq_int @ ( plus_plus_int @ W @ one_one_int ) @ Z_2 ) ) )).

thf(fact_573_succ__def,axiom,(
    ! [K: int] :
      ( ( succ @ K )
      = ( plus_plus_int @ K @ one_one_int ) ) )).

thf(fact_574_power__eq__imp__eq__base,axiom,(
    ! [A_7: real,N_3: nat,B_6: real] :
      ( ( ( power_power_real @ A_7 @ N_3 )
        = ( power_power_real @ B_6 @ N_3 ) )
     => ( ( ord_less_eq_real @ zero_zero_real @ A_7 )
       => ( ( ord_less_eq_real @ zero_zero_real @ B_6 )
         => ( ( ord_less_nat @ zero_zero_nat @ N_3 )
           => ( A_7 = B_6 ) ) ) ) ) )).

thf(fact_575_power__eq__imp__eq__base,axiom,(
    ! [A_7: nat,N_3: nat,B_6: nat] :
      ( ( ( power_power_nat @ A_7 @ N_3 )
        = ( power_power_nat @ B_6 @ N_3 ) )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ A_7 )
       => ( ( ord_less_eq_nat @ zero_zero_nat @ B_6 )
         => ( ( ord_less_nat @ zero_zero_nat @ N_3 )
           => ( A_7 = B_6 ) ) ) ) ) )).

thf(fact_576_power__eq__imp__eq__base,axiom,(
    ! [A_7: int,N_3: nat,B_6: int] :
      ( ( ( power_power_int @ A_7 @ N_3 )
        = ( power_power_int @ B_6 @ N_3 ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ A_7 )
       => ( ( ord_less_eq_int @ zero_zero_int @ B_6 )
         => ( ( ord_less_nat @ zero_zero_nat @ N_3 )
           => ( A_7 = B_6 ) ) ) ) ) )).

thf(fact_577_semiring__add__number__of,axiom,(
    ! [V_4: int,V_3: int] :
      ( ( ord_less_eq_int @ pls @ V_3 )
     => ( ( ord_less_eq_int @ pls @ V_4 )
       => ( ( plus_plus_real @ ( number267125858f_real @ V_3 ) @ ( number267125858f_real @ V_4 ) )
          = ( number267125858f_real @ ( plus_plus_int @ V_3 @ V_4 ) ) ) ) ) )).

thf(fact_578_semiring__add__number__of,axiom,(
    ! [V_4: int,V_3: int] :
      ( ( ord_less_eq_int @ pls @ V_3 )
     => ( ( ord_less_eq_int @ pls @ V_4 )
       => ( ( plus_plus_nat @ ( number_number_of_nat @ V_3 ) @ ( number_number_of_nat @ V_4 ) )
          = ( number_number_of_nat @ ( plus_plus_int @ V_3 @ V_4 ) ) ) ) ) )).

thf(fact_579_semiring__add__number__of,axiom,(
    ! [V_4: int,V_3: int] :
      ( ( ord_less_eq_int @ pls @ V_3 )
     => ( ( ord_less_eq_int @ pls @ V_4 )
       => ( ( plus_plus_int @ ( number_number_of_int @ V_3 ) @ ( number_number_of_int @ V_4 ) )
          = ( number_number_of_int @ ( plus_plus_int @ V_3 @ V_4 ) ) ) ) ) )).

thf(fact_580_Nat__Transfer_Otransfer__nat__int__function__closures_I8_J,axiom,
    ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ ( bit1 @ ( bit1 @ pls ) ) ) )).

thf(fact_581_le__imp__0__less,axiom,(
    ! [Z_2: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z_2 )
     => ( ord_less_int @ zero_zero_int @ ( plus_plus_int @ one_one_int @ Z_2 ) ) ) )).

thf(fact_582_number__of__succ,axiom,(
    ! [K_2: int] :
      ( ( number267125858f_real @ ( succ @ K_2 ) )
      = ( plus_plus_real @ one_one_real @ ( number267125858f_real @ K_2 ) ) ) )).

thf(fact_583_number__of__succ,axiom,(
    ! [K_2: int] :
      ( ( number_number_of_int @ ( succ @ K_2 ) )
      = ( plus_plus_int @ one_one_int @ ( number_number_of_int @ K_2 ) ) ) )).

thf(fact_584_add__Bit1__Bit1,axiom,(
    ! [K: int,L: int] :
      ( ( plus_plus_int @ ( bit1 @ K ) @ ( bit1 @ L ) )
      = ( bit0 @ ( plus_plus_int @ K @ ( succ @ L ) ) ) ) )).

thf(fact_585_power__strict__mono,axiom,(
    ! [N_2: nat,A_6: real,B_5: real] :
      ( ( ord_less_real @ A_6 @ B_5 )
     => ( ( ord_less_eq_real @ zero_zero_real @ A_6 )
       => ( ( ord_less_nat @ zero_zero_nat @ N_2 )
         => ( ord_less_real @ ( power_power_real @ A_6 @ N_2 ) @ ( power_power_real @ B_5 @ N_2 ) ) ) ) ) )).

thf(fact_586_power__strict__mono,axiom,(
    ! [N_2: nat,A_6: nat,B_5: nat] :
      ( ( ord_less_nat @ A_6 @ B_5 )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ A_6 )
       => ( ( ord_less_nat @ zero_zero_nat @ N_2 )
         => ( ord_less_nat @ ( power_power_nat @ A_6 @ N_2 ) @ ( power_power_nat @ B_5 @ N_2 ) ) ) ) ) )).

thf(fact_587_power__strict__mono,axiom,(
    ! [N_2: nat,A_6: int,B_5: int] :
      ( ( ord_less_int @ A_6 @ B_5 )
     => ( ( ord_less_eq_int @ zero_zero_int @ A_6 )
       => ( ( ord_less_nat @ zero_zero_nat @ N_2 )
         => ( ord_less_int @ ( power_power_int @ A_6 @ N_2 ) @ ( power_power_int @ B_5 @ N_2 ) ) ) ) ) )).

thf(fact_588_Nat__Transfer_Otransfer__nat__int__function__closures_I7_J,axiom,
    ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) )).

thf(fact_589_power2__ge__self,axiom,(
    ! [X: int] :
      ( ord_less_eq_int @ X @ ( power_power_int @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) )).

thf(fact_590_zero__le__power2,axiom,(
    ! [A_5: real] :
      ( ord_less_eq_real @ zero_zero_real @ ( power_power_real @ A_5 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) )).

thf(fact_591_zero__le__power2,axiom,(
    ! [A_5: int] :
      ( ord_less_eq_int @ zero_zero_int @ ( power_power_int @ A_5 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) )).

thf(fact_592_power2__le__imp__le,axiom,(
    ! [X_13: real,Y_12: real] :
      ( ( ord_less_eq_real @ ( power_power_real @ X_13 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_real @ zero_zero_real @ Y_12 )
       => ( ord_less_eq_real @ X_13 @ Y_12 ) ) ) )).

thf(fact_593_power2__le__imp__le,axiom,(
    ! [X_13: nat,Y_12: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ X_13 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_nat @ Y_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ Y_12 )
       => ( ord_less_eq_nat @ X_13 @ Y_12 ) ) ) )).

thf(fact_594_power2__le__imp__le,axiom,(
    ! [X_13: int,Y_12: int] :
      ( ( ord_less_eq_int @ ( power_power_int @ X_13 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ Y_12 )
       => ( ord_less_eq_int @ X_13 @ Y_12 ) ) ) )).

thf(fact_595_power2__eq__imp__eq,axiom,(
    ! [X_12: real,Y_11: real] :
      ( ( ( power_power_real @ X_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
        = ( power_power_real @ Y_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_real @ zero_zero_real @ X_12 )
       => ( ( ord_less_eq_real @ zero_zero_real @ Y_11 )
         => ( X_12 = Y_11 ) ) ) ) )).

thf(fact_596_power2__eq__imp__eq,axiom,(
    ! [X_12: nat,Y_11: nat] :
      ( ( ( power_power_nat @ X_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
        = ( power_power_nat @ Y_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ X_12 )
       => ( ( ord_less_eq_nat @ zero_zero_nat @ Y_11 )
         => ( X_12 = Y_11 ) ) ) ) )).

thf(fact_597_power2__eq__imp__eq,axiom,(
    ! [X_12: int,Y_11: int] :
      ( ( ( power_power_int @ X_12 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
        = ( power_power_int @ Y_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ X_12 )
       => ( ( ord_less_eq_int @ zero_zero_int @ Y_11 )
         => ( X_12 = Y_11 ) ) ) ) )).

thf(fact_598_of__nat__number__of__lemma,axiom,(
    ! [V_2: int] :
      ( ( ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ V_2 ) )
       => ( ( semiri132038758t_real @ ( number_number_of_nat @ V_2 ) )
          = ( number267125858f_real @ V_2 ) ) )
      & ( ~ ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ V_2 ) )
       => ( ( semiri132038758t_real @ ( number_number_of_nat @ V_2 ) )
          = zero_zero_real ) ) ) )).

thf(fact_599_of__nat__number__of__lemma,axiom,(
    ! [V_2: int] :
      ( ( ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ V_2 ) )
       => ( ( semiri1621563631at_int @ ( number_number_of_nat @ V_2 ) )
          = ( number_number_of_int @ V_2 ) ) )
      & ( ~ ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ V_2 ) )
       => ( ( semiri1621563631at_int @ ( number_number_of_nat @ V_2 ) )
          = zero_zero_int ) ) ) )).

thf(fact_600_power2__less__imp__less,axiom,(
    ! [X_11: real,Y_10: real] :
      ( ( ord_less_real @ ( power_power_real @ X_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_10 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_real @ zero_zero_real @ Y_10 )
       => ( ord_less_real @ X_11 @ Y_10 ) ) ) )).

thf(fact_601_power2__less__imp__less,axiom,(
    ! [X_11: nat,Y_10: nat] :
      ( ( ord_less_nat @ ( power_power_nat @ X_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_nat @ Y_10 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ Y_10 )
       => ( ord_less_nat @ X_11 @ Y_10 ) ) ) )).

thf(fact_602_power2__less__imp__less,axiom,(
    ! [X_11: int,Y_10: int] :
      ( ( ord_less_int @ ( power_power_int @ X_11 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_10 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ Y_10 )
       => ( ord_less_int @ X_11 @ Y_10 ) ) ) )).

thf(fact_603_sum__power2__ge__zero,axiom,(
    ! [X_10: real,Y_9: real] :
      ( ord_less_eq_real @ zero_zero_real @ ( plus_plus_real @ ( power_power_real @ X_10 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_9 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) ) )).

thf(fact_604_sum__power2__ge__zero,axiom,(
    ! [X_10: int,Y_9: int] :
      ( ord_less_eq_int @ zero_zero_int @ ( plus_plus_int @ ( power_power_int @ X_10 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_9 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) ) )).

thf(fact_605_sum__power2__le__zero__iff,axiom,(
    ! [X_9: real,Y_8: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ ( power_power_real @ X_9 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y_8 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) @ zero_zero_real )
    <=> ( ( X_9 = zero_zero_real )
        & ( Y_8 = zero_zero_real ) ) ) )).

thf(fact_606_sum__power2__le__zero__iff,axiom,(
    ! [X_9: int,Y_8: int] :
      ( ( ord_less_eq_int @ ( plus_plus_int @ ( power_power_int @ X_9 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_int @ Y_8 @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) @ zero_zero_int )
    <=> ( ( X_9 = zero_zero_int )
        & ( Y_8 = zero_zero_int ) ) ) )).

thf(fact_607_int__pos__lt__two__imp__zero__or__one,axiom,(
    ! [X: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ X )
     => ( ( ord_less_int @ X @ ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) )
       => ( ( X = zero_zero_int )
          | ( X = one_one_int ) ) ) ) )).

thf(fact_608_number__of1,axiom,(
    ! [N: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ N ) )
     => ( ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ ( bit0 @ N ) ) )
        & ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ ( bit1 @ N ) ) ) ) ) )).

thf(fact_609_number__of2,axiom,
    ( ord_less_eq_int @ zero_zero_int @ ( number_number_of_int @ pls ) )).

thf(fact_610_zero__le__imp__eq__int,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ K )
     => ? [N_1: nat] :
          ( K
          = ( semiri1621563631at_int @ N_1 ) ) ) )).

thf(fact_611_nonneg__int__cases,axiom,(
    ! [K: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ K )
     => ~ ( ! [N_1: nat] :
              ( K
             != ( semiri1621563631at_int @ N_1 ) ) ) ) )).

thf(fact_612_le0,axiom,(
    ! [N: nat] :
      ( ord_less_eq_nat @ zero_zero_nat @ N ) )).

thf(fact_613_less__eq__nat_Osimps_I1_J,axiom,(
    ! [N: nat] :
      ( ord_less_eq_nat @ zero_zero_nat @ N ) )).

thf(fact_614_le__0__eq,axiom,(
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
    <=> ( N = zero_zero_nat ) ) )).

thf(fact_615_less__or__eq__imp__le,axiom,(
    ! [M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_616_le__neq__implies__less,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( M != N )
       => ( ord_less_nat @ M @ N ) ) ) )).

thf(fact_617_less__imp__le__nat,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_618_le__eq__less__or__eq,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
    <=> ( ( ord_less_nat @ M @ N )
        | ( M = N ) ) ) )).

thf(fact_619_nat__less__le,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
    <=> ( ( ord_less_eq_nat @ M @ N )
        & ( M != N ) ) ) )).

thf(fact_620_le__refl,axiom,(
    ! [N: nat] :
      ( ord_less_eq_nat @ N @ N ) )).

thf(fact_621_nat__le__linear,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) )).

thf(fact_622_eq__imp__le,axiom,(
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_623_le__trans,axiom,(
    ! [K: nat,I: nat,J: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ord_less_eq_nat @ I @ K ) ) ) )).

thf(fact_624_le__antisym,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) )).

thf(fact_625_less__eq__real__def,axiom,(
    ! [X: real,Y: real] :
      ( ( ord_less_eq_real @ X @ Y )
    <=> ( ( ord_less_real @ X @ Y )
        | ( X = Y ) ) ) )).

thf(fact_626_real__less__def,axiom,(
    ! [X: real,Y: real] :
      ( ( ord_less_real @ X @ Y )
    <=> ( ( ord_less_eq_real @ X @ Y )
        & ( X != Y ) ) ) )).

thf(fact_627_le__add2,axiom,(
    ! [N: nat,M: nat] :
      ( ord_less_eq_nat @ N @ ( plus_plus_nat @ M @ N ) ) )).

thf(fact_628_le__add1,axiom,(
    ! [N: nat,M: nat] :
      ( ord_less_eq_nat @ N @ ( plus_plus_nat @ N @ M ) ) )).

thf(fact_629_le__iff__add,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
    <=> ? [K_1: nat] :
          ( N
          = ( plus_plus_nat @ M @ K_1 ) ) ) )).

thf(fact_630_nat__add__left__cancel__le,axiom,(
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
    <=> ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_631_trans__le__add1,axiom,(
    ! [M: nat,I: nat,J: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ I @ ( plus_plus_nat @ J @ M ) ) ) )).

thf(fact_632_trans__le__add2,axiom,(
    ! [M: nat,I: nat,J: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ I @ ( plus_plus_nat @ M @ J ) ) ) )).

thf(fact_633_add__le__mono1,axiom,(
    ! [K: nat,I: nat,J: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ K ) ) ) )).

thf(fact_634_add__le__mono,axiom,(
    ! [K: nat,L: nat,I: nat,J: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ( ord_less_eq_nat @ K @ L )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ) )).

thf(fact_635_add__leD2,axiom,(
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ( ord_less_eq_nat @ K @ N ) ) )).

thf(fact_636_add__leD1,axiom,(
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_637_add__leE,axiom,(
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq_nat @ M @ N )
         => ~ ( ord_less_eq_nat @ K @ N ) ) ) )).

thf(fact_638_real__add__left__mono,axiom,(
    ! [Z_2: real,X: real,Y: real] :
      ( ( ord_less_eq_real @ X @ Y )
     => ( ord_less_eq_real @ ( plus_plus_real @ Z_2 @ X ) @ ( plus_plus_real @ Z_2 @ Y ) ) ) )).

thf(fact_639_Nat__Transfer_Otransfer__int__nat__relations_I3_J,axiom,(
    ! [X: nat,Y: nat] :
      ( ( ord_less_eq_int @ ( semiri1621563631at_int @ X ) @ ( semiri1621563631at_int @ Y ) )
    <=> ( ord_less_eq_nat @ X @ Y ) ) )).

thf(fact_640_zle__int,axiom,(
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_int @ ( semiri1621563631at_int @ M ) @ ( semiri1621563631at_int @ N ) )
    <=> ( ord_less_eq_nat @ M @ N ) ) )).

thf(fact_641_le__nat__number__of,axiom,(
    ! [V_1: int,V: int] :
      ( ( ord_less_eq_nat @ ( number_number_of_nat @ V_1 ) @ ( number_number_of_nat @ V ) )
    <=> ( ~ ( ord_less_eq_int @ V_1 @ V )
       => ( ord_less_eq_int @ V_1 @ pls ) ) ) )).

thf(fact_642_two__realpow__ge__one,axiom,(
    ! [N: nat] :
      ( ord_less_eq_real @ one_one_real @ ( power_power_real @ ( number267125858f_real @ ( bit0 @ ( bit1 @ pls ) ) ) @ N ) ) )).

thf(fact_643_conj__le__cong,axiom,(
    ! [P_1: $o,P: $o,X: int] :
      ( ( ( ord_less_eq_int @ zero_zero_int @ X )
       => ( P
        <=> P_1 ) )
     => ( ( ( ord_less_eq_int @ zero_zero_int @ X )
          & P )
      <=> ( ( ord_less_eq_int @ zero_zero_int @ X )
          & P_1 ) ) ) )).

thf(fact_644_imp__le__cong,axiom,(
    ! [P_1: $o,P: $o,X: int] :
      ( ( ( ord_less_eq_int @ zero_zero_int @ X )
       => ( P
        <=> P_1 ) )
     => ( ( ( ord_less_eq_int @ zero_zero_int @ X )
         => P )
      <=> ( ( ord_less_eq_int @ zero_zero_int @ X )
         => P_1 ) ) ) )).

thf(fact_645_ex__least__nat__less,axiom,(
    ! [N: nat,P: nat > $o] :
      ( ~ ( P @ zero_zero_nat )
     => ( ( P @ N )
       => ? [K_1: nat] :
            ( ( ord_less_nat @ K_1 @ N )
            & ! [I_1: nat] :
                ( ( ord_less_eq_nat @ I_1 @ K_1 )
               => ~ ( P @ I_1 ) )
            & ( P @ ( plus_plus_nat @ K_1 @ one_one_nat ) ) ) ) ) )).

thf(fact_646_nonneg__eq__int,axiom,(
    ! [Z_2: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z_2 )
     => ~ ( ! [M_1: nat] :
              ( Z_2
             != ( semiri1621563631at_int @ M_1 ) ) ) ) )).

thf(fact_647_mono__nat__linear__lb,axiom,(
    ! [M: nat,K: nat,F: nat > nat] :
      ( ! [M_1: nat,N_1: nat] :
          ( ( ord_less_nat @ M_1 @ N_1 )
         => ( ord_less_nat @ ( F @ M_1 ) @ ( F @ N_1 ) ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ ( F @ M ) @ K ) @ ( F @ ( plus_plus_nat @ M @ K ) ) ) ) )).

thf(fact_648_real__le__refl,axiom,(
    ! [W: real] :
      ( ord_less_eq_real @ W @ W ) )).

thf(fact_649_real__le__linear,axiom,(
    ! [Z_2: real,W: real] :
      ( ( ord_less_eq_real @ Z_2 @ W )
      | ( ord_less_eq_real @ W @ Z_2 ) ) )).

thf(fact_650_real__le__trans,axiom,(
    ! [K: real,I: real,J: real] :
      ( ( ord_less_eq_real @ I @ J )
     => ( ( ord_less_eq_real @ J @ K )
       => ( ord_less_eq_real @ I @ K ) ) ) )).

thf(fact_651_real__le__antisym,axiom,(
    ! [Z_2: real,W: real] :
      ( ( ord_less_eq_real @ Z_2 @ W )
     => ( ( ord_less_eq_real @ W @ Z_2 )
       => ( Z_2 = W ) ) ) )).

thf(fact_652_int__ge__induct,axiom,(
    ! [P: int > $o,K: int,I: int] :
      ( ( ord_less_eq_int @ K @ I )
     => ( ( P @ K )
       => ( ! [I_1: int] :
              ( ( ord_less_eq_int @ K @ I_1 )
             => ( ( P @ I_1 )
               => ( P @ ( plus_plus_int @ I_1 @ one_one_int ) ) ) )
         => ( P @ I ) ) ) ) )).

thf(fact_653_ex__least__nat__le,axiom,(
    ! [N: nat,P: nat > $o] :
      ( ~ ( P @ zero_zero_nat )
     => ( ( P @ N )
       => ? [K_1: nat] :
            ( ( ord_less_eq_nat @ K_1 @ N )
            & ! [I_1: nat] :
                ( ( ord_less_nat @ I_1 @ K_1 )
               => ~ ( P @ I_1 ) )
            & ( P @ K_1 ) ) ) ) )).

thf(fact_654_less__mono__imp__le__mono,axiom,(
    ! [I: nat,J: nat,F: nat > nat] :
      ( ! [I_1: nat,J_1: nat] :
          ( ( ord_less_nat @ I_1 @ J_1 )
         => ( ord_less_nat @ ( F @ I_1 ) @ ( F @ J_1 ) ) )
     => ( ( ord_less_eq_nat @ I @ J )
       => ( ord_less_eq_nat @ ( F @ I ) @ ( F @ J ) ) ) ) )).

thf(fact_655_order__refl,axiom,(
    ! [X_8: real] :
      ( ord_less_eq_real @ X_8 @ X_8 ) )).

thf(fact_656_order__refl,axiom,(
    ! [X_8: nat] :
      ( ord_less_eq_nat @ X_8 @ X_8 ) )).

thf(fact_657_order__refl,axiom,(
    ! [X_8: int] :
      ( ord_less_eq_int @ X_8 @ X_8 ) )).

thf(fact_658_linorder__le__cases,axiom,(
    ! [X_7: real,Y_7: real] :
      ( ~ ( ord_less_eq_real @ X_7 @ Y_7 )
     => ( ord_less_eq_real @ Y_7 @ X_7 ) ) )).

thf(fact_659_linorder__le__cases,axiom,(
    ! [X_7: nat,Y_7: nat] :
      ( ~ ( ord_less_eq_nat @ X_7 @ Y_7 )
     => ( ord_less_eq_nat @ Y_7 @ X_7 ) ) )).

thf(fact_660_linorder__le__cases,axiom,(
    ! [X_7: int,Y_7: int] :
      ( ~ ( ord_less_eq_int @ X_7 @ Y_7 )
     => ( ord_less_eq_int @ Y_7 @ X_7 ) ) )).

thf(fact_661_xt1_I6_J,axiom,(
    ! [Z_1: real,Y_6: real,X_6: real] :
      ( ( ord_less_eq_real @ Y_6 @ X_6 )
     => ( ( ord_less_eq_real @ Z_1 @ Y_6 )
       => ( ord_less_eq_real @ Z_1 @ X_6 ) ) ) )).

thf(fact_662_xt1_I6_J,axiom,(
    ! [Z_1: nat,Y_6: nat,X_6: nat] :
      ( ( ord_less_eq_nat @ Y_6 @ X_6 )
     => ( ( ord_less_eq_nat @ Z_1 @ Y_6 )
       => ( ord_less_eq_nat @ Z_1 @ X_6 ) ) ) )).

thf(fact_663_xt1_I6_J,axiom,(
    ! [Z_1: int,Y_6: int,X_6: int] :
      ( ( ord_less_eq_int @ Y_6 @ X_6 )
     => ( ( ord_less_eq_int @ Z_1 @ Y_6 )
       => ( ord_less_eq_int @ Z_1 @ X_6 ) ) ) )).

thf(fact_664_xt1_I5_J,axiom,(
    ! [Y_5: real,X_5: real] :
      ( ( ord_less_eq_real @ Y_5 @ X_5 )
     => ( ( ord_less_eq_real @ X_5 @ Y_5 )
       => ( X_5 = Y_5 ) ) ) )).

thf(fact_665_xt1_I5_J,axiom,(
    ! [Y_5: nat,X_5: nat] :
      ( ( ord_less_eq_nat @ Y_5 @ X_5 )
     => ( ( ord_less_eq_nat @ X_5 @ Y_5 )
       => ( X_5 = Y_5 ) ) ) )).

thf(fact_666_xt1_I5_J,axiom,(
    ! [Y_5: int,X_5: int] :
      ( ( ord_less_eq_int @ Y_5 @ X_5 )
     => ( ( ord_less_eq_int @ X_5 @ Y_5 )
       => ( X_5 = Y_5 ) ) ) )).

thf(fact_667_order__trans,axiom,(
    ! [Z: real,X_4: real,Y_4: real] :
      ( ( ord_less_eq_real @ X_4 @ Y_4 )
     => ( ( ord_less_eq_real @ Y_4 @ Z )
       => ( ord_less_eq_real @ X_4 @ Z ) ) ) )).

thf(fact_668_order__trans,axiom,(
    ! [Z: nat,X_4: nat,Y_4: nat] :
      ( ( ord_less_eq_nat @ X_4 @ Y_4 )
     => ( ( ord_less_eq_nat @ Y_4 @ Z )
       => ( ord_less_eq_nat @ X_4 @ Z ) ) ) )).

thf(fact_669_order__trans,axiom,(
    ! [Z: int,X_4: int,Y_4: int] :
      ( ( ord_less_eq_int @ X_4 @ Y_4 )
     => ( ( ord_less_eq_int @ Y_4 @ Z )
       => ( ord_less_eq_int @ X_4 @ Z ) ) ) )).

thf(fact_670_order__antisym,axiom,(
    ! [X_3: real,Y_3: real] :
      ( ( ord_less_eq_real @ X_3 @ Y_3 )
     => ( ( ord_less_eq_real @ Y_3 @ X_3 )
       => ( X_3 = Y_3 ) ) ) )).

thf(fact_671_order__antisym,axiom,(
    ! [X_3: nat,Y_3: nat] :
      ( ( ord_less_eq_nat @ X_3 @ Y_3 )
     => ( ( ord_less_eq_nat @ Y_3 @ X_3 )
       => ( X_3 = Y_3 ) ) ) )).

thf(fact_672_order__antisym,axiom,(
    ! [X_3: int,Y_3: int] :
      ( ( ord_less_eq_int @ X_3 @ Y_3 )
     => ( ( ord_less_eq_int @ Y_3 @ X_3 )
       => ( X_3 = Y_3 ) ) ) )).

thf(fact_673_xt1_I4_J,axiom,(
    ! [C_3: real,B_4: real,A_4: real] :
      ( ( ord_less_eq_real @ B_4 @ A_4 )
     => ( ( B_4 = C_3 )
       => ( ord_less_eq_real @ C_3 @ A_4 ) ) ) )).

thf(fact_674_xt1_I4_J,axiom,(
    ! [C_3: nat,B_4: nat,A_4: nat] :
      ( ( ord_less_eq_nat @ B_4 @ A_4 )
     => ( ( B_4 = C_3 )
       => ( ord_less_eq_nat @ C_3 @ A_4 ) ) ) )).

thf(fact_675_xt1_I4_J,axiom,(
    ! [C_3: int,B_4: int,A_4: int] :
      ( ( ord_less_eq_int @ B_4 @ A_4 )
     => ( ( B_4 = C_3 )
       => ( ord_less_eq_int @ C_3 @ A_4 ) ) ) )).

thf(fact_676_ord__le__eq__trans,axiom,(
    ! [C_2: real,A_3: real,B_3: real] :
      ( ( ord_less_eq_real @ A_3 @ B_3 )
     => ( ( B_3 = C_2 )
       => ( ord_less_eq_real @ A_3 @ C_2 ) ) ) )).

thf(fact_677_ord__le__eq__trans,axiom,(
    ! [C_2: nat,A_3: nat,B_3: nat] :
      ( ( ord_less_eq_nat @ A_3 @ B_3 )
     => ( ( B_3 = C_2 )
       => ( ord_less_eq_nat @ A_3 @ C_2 ) ) ) )).

thf(fact_678_ord__le__eq__trans,axiom,(
    ! [C_2: int,A_3: int,B_3: int] :
      ( ( ord_less_eq_int @ A_3 @ B_3 )
     => ( ( B_3 = C_2 )
       => ( ord_less_eq_int @ A_3 @ C_2 ) ) ) )).

thf(fact_679_xt1_I3_J,axiom,(
    ! [C_1: real,A_2: real,B_2: real] :
      ( ( A_2 = B_2 )
     => ( ( ord_less_eq_real @ C_1 @ B_2 )
       => ( ord_less_eq_real @ C_1 @ A_2 ) ) ) )).

thf(fact_680_xt1_I3_J,axiom,(
    ! [C_1: nat,A_2: nat,B_2: nat] :
      ( ( A_2 = B_2 )
     => ( ( ord_less_eq_nat @ C_1 @ B_2 )
       => ( ord_less_eq_nat @ C_1 @ A_2 ) ) ) )).

thf(fact_681_xt1_I3_J,axiom,(
    ! [C_1: int,A_2: int,B_2: int] :
      ( ( A_2 = B_2 )
     => ( ( ord_less_eq_int @ C_1 @ B_2 )
       => ( ord_less_eq_int @ C_1 @ A_2 ) ) ) )).

thf(fact_682_ord__eq__le__trans,axiom,(
    ! [C: real,A_1: real,B_1: real] :
      ( ( A_1 = B_1 )
     => ( ( ord_less_eq_real @ B_1 @ C )
       => ( ord_less_eq_real @ A_1 @ C ) ) ) )).

thf(fact_683_ord__eq__le__trans,axiom,(
    ! [C: nat,A_1: nat,B_1: nat] :
      ( ( A_1 = B_1 )
     => ( ( ord_less_eq_nat @ B_1 @ C )
       => ( ord_less_eq_nat @ A_1 @ C ) ) ) )).

thf(fact_684_ord__eq__le__trans,axiom,(
    ! [C: int,A_1: int,B_1: int] :
      ( ( A_1 = B_1 )
     => ( ( ord_less_eq_int @ B_1 @ C )
       => ( ord_less_eq_int @ A_1 @ C ) ) ) )).

thf(fact_685_order__antisym__conv,axiom,(
    ! [Y_2: real,X_2: real] :
      ( ( ord_less_eq_real @ Y_2 @ X_2 )
     => ( ( ord_less_eq_real @ X_2 @ Y_2 )
      <=> ( X_2 = Y_2 ) ) ) )).

thf(fact_686_order__antisym__conv,axiom,(
    ! [Y_2: nat,X_2: nat] :
      ( ( ord_less_eq_nat @ Y_2 @ X_2 )
     => ( ( ord_less_eq_nat @ X_2 @ Y_2 )
      <=> ( X_2 = Y_2 ) ) ) )).

thf(fact_687_order__antisym__conv,axiom,(
    ! [Y_2: int,X_2: int] :
      ( ( ord_less_eq_int @ Y_2 @ X_2 )
     => ( ( ord_less_eq_int @ X_2 @ Y_2 )
      <=> ( X_2 = Y_2 ) ) ) )).

thf(fact_688_order__eq__refl,axiom,(
    ! [X_1: int,Y_1: int] :
      ( ( X_1 = Y_1 )
     => ( ord_less_eq_int @ X_1 @ Y_1 ) ) )).

thf(fact_689_real__lbound__gt__zero,axiom,(
    ! [D2: real,D1: real] :
      ( ( ord_less_real @ zero_zero_real @ D1 )
     => ( ( ord_less_real @ zero_zero_real @ D2 )
       => ? [E: real] :
            ( ( ord_less_real @ zero_zero_real @ E )
            & ( ord_less_real @ E @ D1 )
            & ( ord_less_real @ E @ D2 ) ) ) ) )).

thf(fact_690_real__sqrt__sum__squares__ge__zero,axiom,(
    ! [X: real,Y: real] :
      ( ord_less_eq_real @ zero_zero_real @ ( sqrt @ ( plus_plus_real @ ( power_power_real @ X @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( power_power_real @ Y @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) ) ) )).

thf(fact_691_zadd__power2,axiom,(
    ! [A: int,B: int] :
      ( ( power_power_int @ ( plus_plus_int @ A @ B ) @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
      = ( plus_plus_int @ ( plus_plus_int @ ( power_power_int @ A @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) @ ( times_times_int @ ( times_times_int @ ( number_number_of_int @ ( bit0 @ ( bit1 @ pls ) ) ) @ A ) @ B ) ) @ ( power_power_int @ B @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) ) ) ) )).

thf(fact_692_mult__Bit1,axiom,(
    ! [K: int,L: int] :
      ( ( times_times_int @ ( bit1 @ K ) @ L )
      = ( plus_plus_int @ ( bit0 @ ( times_times_int @ K @ L ) ) @ L ) ) )).

thf(fact_693_real__sqrt__gt__zero,axiom,(
    ! [X: real] :
      ( ( ord_less_real @ zero_zero_real @ X )
     => ( ord_less_real @ zero_zero_real @ ( sqrt @ X ) ) ) )).

thf(fact_694_real__sqrt__not__eq__zero,axiom,(
    ! [X: real] :
      ( ( ord_less_real @ zero_zero_real @ X )
     => ( ( sqrt @ X )
       != zero_zero_real ) ) )).

thf(fact_695_real__sqrt__lt__0__iff,axiom,(
    ! [X: real] :
      ( ( ord_less_real @ ( sqrt @ X ) @ zero_zero_real )
    <=> ( ord_less_real @ X @ zero_zero_real ) ) )).

thf(fact_696_real__sqrt__gt__0__iff,axiom,(
    ! [Y: real] :
      ( ( ord_less_real @ zero_zero_real @ ( sqrt @ Y ) )
    <=> ( ord_less_real @ zero_zero_real @ Y ) ) )).

thf(fact_697_real__sqrt__lt__1__iff,axiom,(
    ! [X: real] :
      ( ( ord_less_real @ ( sqrt @ X ) @ one_one_real )
    <=> ( ord_less_real @ X @ one_one_real ) ) )).

thf(fact_698_real__sqrt__gt__1__iff,axiom,(
    ! [Y: real] :
      ( ( ord_less_real @ one_one_real @ ( sqrt @ Y ) )
    <=> ( ord_less_real @ one_one_real @ Y ) ) )).

%----Helper facts (3)
thf(help_If_1_1_If_000tc__Nat__Onat_T,axiom,(
    ! [X: nat,Y: nat] :
      ( ( if_nat @ $true @ X @ Y )
      = X ) )).

thf(help_If_2_1_If_000tc__Nat__Onat_T,axiom,(
    ! [X: nat,Y: nat] :
      ( ( if_nat @ $false @ X @ Y )
      = Y ) )).

thf(help_If_3_1_If_000tc__Nat__Onat_T,axiom,(
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) )).

%----Conjectures (1)
thf(conj_0,conjecture,(
    ( power_power_int @ ( plus_plus_int @ one_one_int @ ( semiri1621563631at_int @ n ) ) @ ( number_number_of_nat @ ( bit0 @ ( bit1 @ pls ) ) ) )
 != zero_zero_int )).

%------------------------------------------------------------------------------
